<?php

namespace EnumType;

/**
 * This class stands for RequestType EnumType
 * @subpackage Enumerations
 */
class RequestType
{
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_DELETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPDATE,
            self::VALUE_DELETE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
