<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responseDetail StructType
 * Meta informations extracted from the WSDL
 * - type: tns:responseDetail
 * - value: ok
 * @subpackage Structs
 */
class ResponseDetail extends AbstractStructBase
{
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The errorCode
     * @var string
     */
    public $errorCode;
    /**
     * The errorDescription
     * @var string
     */
    public $errorDescription;
    /**
     * Constructor method for responseDetail
     * @uses ResponseDetail::setStatus()
     * @uses ResponseDetail::setErrorCode()
     * @uses ResponseDetail::setErrorDescription()
     * @param string $status
     * @param string $errorCode
     * @param string $errorDescription
     */
    public function __construct($status = null, $errorCode = null, $errorDescription = null)
    {
        $this
            ->setStatus($status)
            ->setErrorCode($errorCode)
            ->setErrorDescription($errorDescription);
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \GreenwayDirectService\StructType\ResponseDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \GreenwayDirectService\StructType\ResponseDetail
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorDescription value
     * @return string|null
     */
    public function getErrorDescription()
    {
        return $this->errorDescription;
    }
    /**
     * Set errorDescription value
     * @param string $errorDescription
     * @return \GreenwayDirectService\StructType\ResponseDetail
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorDescription)), __LINE__);
        }
        $this->errorDescription = $errorDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\ResponseDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
