<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driverDetailsType StructType
 * @subpackage Structs
 */
class DriverDetailsType extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 1
     * @var \GreenwayDirectService\StructType\RentalAddressType[]
     */
    public $address;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxLength: 10
     * @var string
     */
    public $title;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 25
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxLength: 25
     * @var string
     */
    public $lastName;
    /**
     * The countryOfResidence
     * Meta informations extracted from the WSDL
     * - length: 2
     * @var string
     */
    public $countryOfResidence;
    /**
     * The dateOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $dateOfBirth;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * - pattern: (.)+@(.)+.(.)
     * @var string
     */
    public $email;
    /**
     * The licence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\LicenceType
     */
    public $licence;
    /**
     * Constructor method for driverDetailsType
     * @uses DriverDetailsType::setAddress()
     * @uses DriverDetailsType::setTitle()
     * @uses DriverDetailsType::setFirstName()
     * @uses DriverDetailsType::setLastName()
     * @uses DriverDetailsType::setCountryOfResidence()
     * @uses DriverDetailsType::setDateOfBirth()
     * @uses DriverDetailsType::setEmail()
     * @uses DriverDetailsType::setLicence()
     * @param \GreenwayDirectService\StructType\RentalAddressType[] $address
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     * @param string $countryOfResidence
     * @param string $dateOfBirth
     * @param string $email
     * @param \GreenwayDirectService\StructType\LicenceType $licence
     */
    public function __construct(array $address = array(), $title = null, $firstName = null, $lastName = null, $countryOfResidence = null, $dateOfBirth = null, $email = null, \GreenwayDirectService\StructType\LicenceType $licence = null)
    {
        $this
            ->setAddress($address)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCountryOfResidence($countryOfResidence)
            ->setDateOfBirth($dateOfBirth)
            ->setEmail($email)
            ->setLicence($licence);
    }
    /**
     * Get address value
     * @return \GreenwayDirectService\StructType\RentalAddressType[]
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\RentalAddressType[] $address
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $driverDetailsTypeAddressItem) {
            // validation for constraint: itemType
            if (!$driverDetailsTypeAddressItem instanceof \GreenwayDirectService\StructType\RentalAddressType) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of \GreenwayDirectService\StructType\RentalAddressType, "%s" given', is_object($driverDetailsTypeAddressItem) ? get_class($driverDetailsTypeAddressItem) : gettype($driverDetailsTypeAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\RentalAddressType $item
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function addToAddress(\GreenwayDirectService\StructType\RentalAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\RentalAddressType) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of \GreenwayDirectService\StructType\RentalAddressType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($title) && strlen($title) > 10) || (is_array($title) && count($title) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($title) ? strlen($title) : count($title)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($firstName) && strlen($firstName) > 25) || (is_array($firstName) && count($firstName) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($firstName) ? strlen($firstName) : count($firstName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lastName) && strlen($lastName) > 25) || (is_array($lastName) && count($lastName) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($lastName) ? strlen($lastName) : count($lastName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get countryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->countryOfResidence;
    }
    /**
     * Set countryOfResidence value
     * @param string $countryOfResidence
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: length
        if ((is_scalar($countryOfResidence) && strlen($countryOfResidence) !== 2) || (is_array($countryOfResidence) && count($countryOfResidence) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfResidence)), __LINE__);
        }
        $this->countryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get dateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->dateOfBirth;
    }
    /**
     * Set dateOfBirth value
     * @param string $dateOfBirth
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: length
        if ((is_scalar($dateOfBirth) && strlen($dateOfBirth) !== 10) || (is_array($dateOfBirth) && count($dateOfBirth) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($dateOfBirth) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($dateOfBirth, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfBirth)), __LINE__);
        }
        $this->dateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 50) || (is_array($email) && count($email) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($email) && !preg_match('/(.)+@(.)+.(.)/', $email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(.)+@(.)+.(.)", "%s" given', var_export($email, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get licence value
     * @return \GreenwayDirectService\StructType\LicenceType|null
     */
    public function getLicence()
    {
        return $this->licence;
    }
    /**
     * Set licence value
     * @param \GreenwayDirectService\StructType\LicenceType $licence
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setLicence(\GreenwayDirectService\StructType\LicenceType $licence = null)
    {
        $this->licence = $licence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
