<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for phoneNumberType StructType
 * @subpackage Structs
 */
class PhoneNumberType extends AbstractStructBase
{
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * @var string
     */
    public $phoneNumber;
    /**
     * The phoneType
     * @var string
     */
    public $phoneType;
    /**
     * Constructor method for phoneNumberType
     * @uses PhoneNumberType::setPhoneNumber()
     * @uses PhoneNumberType::setPhoneType()
     * @param string $phoneNumber
     * @param string $phoneType
     */
    public function __construct($phoneNumber = null, $phoneType = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setPhoneType($phoneType);
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \GreenwayDirectService\StructType\PhoneNumberType
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phoneNumber) && strlen($phoneNumber) > 15) || (is_array($phoneNumber) && count($phoneNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($phoneNumber) ? strlen($phoneNumber) : count($phoneNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @uses \GreenwayDirectService\EnumType\PhoneType::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\PhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return \GreenwayDirectService\StructType\PhoneNumberType
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\PhoneType::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneType, implode(', ', \GreenwayDirectService\EnumType\PhoneType::getValidValues())), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\PhoneNumberType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
