<?php

namespace GreenwayFirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reservation StructType
 * @subpackage Structs
 */
class Reservation extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayFirectService\StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reservationNumber;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - totalDigits: 8
     * @var int
     */
    public $contractId;
    /**
     * The modelRequested
     * Meta informations extracted from the WSDL
     * - pattern: [A-Z]{4}
     * - type: acrissCode
     * @var string
     */
    public $modelRequested;
    /**
     * The contactTelNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $contactTelNo;
    /**
     * The contactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 25
     * @var string
     */
    public $contactName;
    /**
     * The iataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNumber;
    /**
     * The start
     * @var \GreenwayFirectService\StructType\WhenAndWhereDetails
     */
    public $start;
    /**
     * The end
     * @var \GreenwayFirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * @var \GreenwayFirectService\StructType\DriverType[]
     */
    public $driver;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\PaymentType[]
     */
    public $payment;
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 13
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\CustomerReferenceType[]
     */
    public $customerReference;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $note;
    /**
     * The equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\EquipmentDetail[]
     */
    public $equipment;
    /**
     * The charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\ChargeDetail[]
     */
    public $charges;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for reservation
     * @uses Reservation::setAuthentication()
     * @uses Reservation::setReservationNumber()
     * @uses Reservation::setStatus()
     * @uses Reservation::setContractId()
     * @uses Reservation::setModelRequested()
     * @uses Reservation::setContactTelNo()
     * @uses Reservation::setContactName()
     * @uses Reservation::setIataNumber()
     * @uses Reservation::setFlightNumber()
     * @uses Reservation::setStart()
     * @uses Reservation::setEnd()
     * @uses Reservation::setDriver()
     * @uses Reservation::setPayment()
     * @uses Reservation::setCustomerReference()
     * @uses Reservation::setNote()
     * @uses Reservation::setEquipment()
     * @uses Reservation::setCharges()
     * @uses Reservation::setError()
     * @param \GreenwayFirectService\StructType\AuthenticationType $authentication
     * @param int $reservationNumber
     * @param string $status
     * @param int $contractId
     * @param string $modelRequested
     * @param string $contactTelNo
     * @param string $contactName
     * @param string $iataNumber
     * @param string $flightNumber
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $start
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $end
     * @param \GreenwayFirectService\StructType\DriverType[] $driver
     * @param \GreenwayFirectService\StructType\PaymentType[] $payment
     * @param \GreenwayFirectService\StructType\CustomerReferenceType[] $customerReference
     * @param string[] $note
     * @param \GreenwayFirectService\StructType\EquipmentDetail[] $equipment
     * @param \GreenwayFirectService\StructType\ChargeDetail[] $charges
     * @param \GreenwayFirectService\StructType\ErrorType[] $error
     */
    public function __construct(\GreenwayFirectService\StructType\AuthenticationType $authentication = null, $reservationNumber = null, $status = null, $contractId = null, $modelRequested = null, $contactTelNo = null, $contactName = null, $iataNumber = null, $flightNumber = null, \GreenwayFirectService\StructType\WhenAndWhereDetails $start = null, \GreenwayFirectService\StructType\WhenAndWhereDetails $end = null, array $driver = array(), array $payment = array(), array $customerReference = array(), array $note = array(), array $equipment = array(), array $charges = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setStatus($status)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setContactTelNo($contactTelNo)
            ->setContactName($contactName)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setEquipment($equipment)
            ->setCharges($charges)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayFirectService\StructType\AuthenticationType|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayFirectService\StructType\AuthenticationType $authentication
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setAuthentication(\GreenwayFirectService\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \GreenwayFirectService\EnumType\StatusCodeType::valueIsValid()
     * @uses \GreenwayFirectService\EnumType\StatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayFirectService\EnumType\StatusCodeType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \GreenwayFirectService\EnumType\StatusCodeType::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get contractId value
     * @return int|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param int $contractId
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($contractId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $contractId)) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 8 digits, "%d" given', strlen(substr($contractId, strpos($contractId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($contractId) && !is_numeric($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return string|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param string $modelRequested
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setModelRequested($modelRequested = null)
    {
        // validation for constraint: pattern
        if (is_scalar($modelRequested) && !preg_match('/[A-Z]{4}/', $modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]{4}", "%s" given', var_export($modelRequested, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modelRequested) && !is_string($modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelRequested)), __LINE__);
        }
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get contactTelNo value
     * @return string|null
     */
    public function getContactTelNo()
    {
        return $this->contactTelNo;
    }
    /**
     * Set contactTelNo value
     * @param string $contactTelNo
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setContactTelNo($contactTelNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactTelNo) && strlen($contactTelNo) > 15) || (is_array($contactTelNo) && count($contactTelNo) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($contactTelNo) ? strlen($contactTelNo) : count($contactTelNo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactTelNo) && !is_string($contactTelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactTelNo)), __LINE__);
        }
        $this->contactTelNo = $contactTelNo;
        return $this;
    }
    /**
     * Get contactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->contactName;
    }
    /**
     * Set contactName value
     * @param string $contactName
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactName) && strlen($contactName) > 25) || (is_array($contactName) && count($contactName) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($contactName) ? strlen($contactName) : count($contactName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->contactName = $contactName;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get start value
     * @return \GreenwayFirectService\StructType\WhenAndWhereDetails|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $start
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setStart(\GreenwayFirectService\StructType\WhenAndWhereDetails $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayFirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setEnd(\GreenwayFirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return \GreenwayFirectService\StructType\DriverType[]|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\DriverType[] $driver
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $reservationDriverItem) {
            // validation for constraint: itemType
            if (!$reservationDriverItem instanceof \GreenwayFirectService\StructType\DriverType) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayFirectService\StructType\DriverType, "%s" given', is_object($reservationDriverItem) ? get_class($reservationDriverItem) : gettype($reservationDriverItem)), __LINE__);
            }
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\DriverType $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToDriver(\GreenwayFirectService\StructType\DriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\DriverType) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayFirectService\StructType\DriverType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Get payment value
     * @return \GreenwayFirectService\StructType\PaymentType[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\PaymentType[] $payment
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $reservationPaymentItem) {
            // validation for constraint: itemType
            if (!$reservationPaymentItem instanceof \GreenwayFirectService\StructType\PaymentType) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayFirectService\StructType\PaymentType, "%s" given', is_object($reservationPaymentItem) ? get_class($reservationPaymentItem) : gettype($reservationPaymentItem)), __LINE__);
            }
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\PaymentType $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToPayment(\GreenwayFirectService\StructType\PaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\PaymentType) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayFirectService\StructType\PaymentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get customerReference value
     * @return \GreenwayFirectService\StructType\CustomerReferenceType[]|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\CustomerReferenceType[] $customerReference
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setCustomerReference(array $customerReference = array())
    {
        foreach ($customerReference as $reservationCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!$reservationCustomerReferenceItem instanceof \GreenwayFirectService\StructType\CustomerReferenceType) {
                throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayFirectService\StructType\CustomerReferenceType, "%s" given', is_object($reservationCustomerReferenceItem) ? get_class($reservationCustomerReferenceItem) : gettype($reservationCustomerReferenceItem)), __LINE__);
            }
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\CustomerReferenceType $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToCustomerReference(\GreenwayFirectService\StructType\CustomerReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\CustomerReferenceType) {
            throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayFirectService\StructType\CustomerReferenceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerReference[] = $item;
        return $this;
    }
    /**
     * Get note value
     * @return string[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param string[] $note
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($note) && strlen($note) > 50) || (is_array($note) && count($note) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($note) ? strlen($note) : count($note)), __LINE__);
        }
        foreach ($note as $reservationNoteItem) {
            // validation for constraint: itemType
            if (!is_string($reservationNoteItem)) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($reservationNoteItem) ? get_class($reservationNoteItem) : gettype($reservationNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToNote($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get equipment value
     * @return \GreenwayFirectService\StructType\EquipmentDetail[]|null
     */
    public function getEquipment()
    {
        return $this->equipment;
    }
    /**
     * Set equipment value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\EquipmentDetail[] $equipment
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $reservationEquipmentItem) {
            // validation for constraint: itemType
            if (!$reservationEquipmentItem instanceof \GreenwayFirectService\StructType\EquipmentDetail) {
                throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \GreenwayFirectService\StructType\EquipmentDetail, "%s" given', is_object($reservationEquipmentItem) ? get_class($reservationEquipmentItem) : gettype($reservationEquipmentItem)), __LINE__);
            }
        }
        $this->equipment = $equipment;
        return $this;
    }
    /**
     * Add item to equipment value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\EquipmentDetail $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToEquipment(\GreenwayFirectService\StructType\EquipmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\EquipmentDetail) {
            throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \GreenwayFirectService\StructType\EquipmentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->equipment[] = $item;
        return $this;
    }
    /**
     * Get charges value
     * @return \GreenwayFirectService\StructType\ChargeDetail[]|null
     */
    public function getCharges()
    {
        return $this->charges;
    }
    /**
     * Set charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ChargeDetail[] $charges
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $reservationChargesItem) {
            // validation for constraint: itemType
            if (!$reservationChargesItem instanceof \GreenwayFirectService\StructType\ChargeDetail) {
                throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayFirectService\StructType\ChargeDetail, "%s" given', is_object($reservationChargesItem) ? get_class($reservationChargesItem) : gettype($reservationChargesItem)), __LINE__);
            }
        }
        $this->charges = $charges;
        return $this;
    }
    /**
     * Add item to charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ChargeDetail $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToCharges(\GreenwayFirectService\StructType\ChargeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\ChargeDetail) {
            throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayFirectService\StructType\ChargeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charges[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayFirectService\StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ErrorType[] $error
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function setError(array $error = array())
    {
        foreach ($error as $reservationErrorItem) {
            // validation for constraint: itemType
            if (!$reservationErrorItem instanceof \GreenwayFirectService\StructType\ErrorType) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayFirectService\StructType\ErrorType, "%s" given', is_object($reservationErrorItem) ? get_class($reservationErrorItem) : gettype($reservationErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ErrorType $item
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public function addToError(\GreenwayFirectService\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayFirectService\StructType\ErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayFirectService\StructType\Reservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
