<?php

namespace GreenwayFirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for equipmentDetail StructType
 * @subpackage Structs
 */
class EquipmentDetail extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for equipmentDetail
     * @uses EquipmentDetail::setCode()
     * @uses EquipmentDetail::setQuantity()
     * @param string $code
     * @param int $quantity
     */
    public function __construct($code = null, $quantity = null)
    {
        $this
            ->setCode($code)
            ->setQuantity($quantity);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \GreenwayFirectService\StructType\EquipmentDetail
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \GreenwayFirectService\StructType\EquipmentDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayFirectService\StructType\EquipmentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
