<?php

namespace GreenwayFirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checkout ServiceType
 * @subpackage Services
 */
class Checkout extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkoutRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayFirectService\StructType\CheckoutRA $parameters
     * @return \GreenwayFirectService\StructType\CheckoutRA|bool
     */
    public function checkoutRA(\GreenwayFirectService\StructType\CheckoutRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkoutRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayFirectService\StructType\CheckoutRA
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
