<?php

namespace GreenwayFirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayFirectService\StructType\CancelReservation $parameters
     * @return \GreenwayFirectService\StructType\CancelReservationResponse|bool
     */
    public function cancelReservation(\GreenwayFirectService\StructType\CancelReservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayFirectService\StructType\CancelRA $parameters
     * @return \GreenwayFirectService\StructType\CancelRA|bool
     */
    public function cancelRA(\GreenwayFirectService\StructType\CancelRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayFirectService\StructType\CancelRA|\GreenwayFirectService\StructType\CancelReservationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
