<?php

namespace GreenwayFirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Amend ServiceType
 * @subpackage Services
 */
class Amend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named amendOffhire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayFirectService\StructType\OffhireDetail $parameters
     * @return \GreenwayFirectService\StructType\OffhireDetail|bool
     */
    public function amendOffhire(\GreenwayFirectService\StructType\OffhireDetail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendOffhire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayFirectService\StructType\AmendReservation $parameters
     * @return \GreenwayFirectService\StructType\AmendReservation|bool
     */
    public function amendReservation(\GreenwayFirectService\StructType\AmendReservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayFirectService\StructType\AmendRA $parameters
     * @return \GreenwayFirectService\StructType\AmendRA|bool
     */
    public function amendRA(\GreenwayFirectService\StructType\AmendRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayFirectService\StructType\AmendRA|\GreenwayFirectService\StructType\AmendReservation|\GreenwayFirectService\StructType\OffhireDetail
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
