<?php

namespace GreenwayFirectService\EnumType;

/**
 * This class stands for fuelType EnumType
 * @subpackage Enumerations
 */
class FuelType
{
    /**
     * Constant for value 'UL'
     * @return string 'UL'
     */
    const VALUE_UL = 'UL';
    /**
     * Constant for value 'SU'
     * @return string 'SU'
     */
    const VALUE_SU = 'SU';
    /**
     * Constant for value 'LE'
     * @return string 'LE'
     */
    const VALUE_LE = 'LE';
    /**
     * Constant for value 'SL'
     * @return string 'SL'
     */
    const VALUE_SL = 'SL';
    /**
     * Constant for value 'DS'
     * @return string 'DS'
     */
    const VALUE_DS = 'DS';
    /**
     * Constant for value 'GP'
     * @return string 'GP'
     */
    const VALUE_GP = 'GP';
    /**
     * Constant for value 'BE'
     * @return string 'BE'
     */
    const VALUE_BE = 'BE';
    /**
     * Constant for value 'EL'
     * @return string 'EL'
     */
    const VALUE_EL = 'EL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UL
     * @uses self::VALUE_SU
     * @uses self::VALUE_LE
     * @uses self::VALUE_SL
     * @uses self::VALUE_DS
     * @uses self::VALUE_GP
     * @uses self::VALUE_BE
     * @uses self::VALUE_EL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UL,
            self::VALUE_SU,
            self::VALUE_LE,
            self::VALUE_SL,
            self::VALUE_DS,
            self::VALUE_GP,
            self::VALUE_BE,
            self::VALUE_EL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
