<?php

namespace GreenwayFirectService\EnumType;

/**
 * This class stands for code EnumType
 * @subpackage Enumerations
 */
class Code
{
    /**
     * Constant for value 'ACTCOD'
     * @return string 'ACTCOD'
     */
    const VALUE_ACTCOD = 'ACTCOD';
    /**
     * Constant for value 'COSCTR'
     * @return string 'COSCTR'
     */
    const VALUE_COSCTR = 'COSCTR';
    /**
     * Constant for value 'INTACC'
     * @return string 'INTACC'
     */
    const VALUE_INTACC = 'INTACC';
    /**
     * Constant for value 'CUSREF'
     * @return string 'CUSREF'
     */
    const VALUE_CUSREF = 'CUSREF';
    /**
     * Constant for value 'ORDNBR'
     * @return string 'ORDNBR'
     */
    const VALUE_ORDNBR = 'ORDNBR';
    /**
     * Constant for value 'AUTCOD'
     * @return string 'AUTCOD'
     */
    const VALUE_AUTCOD = 'AUTCOD';
    /**
     * Constant for value 'EMPNBR'
     * @return string 'EMPNBR'
     */
    const VALUE_EMPNBR = 'EMPNBR';
    /**
     * Constant for value 'DVRNBR'
     * @return string 'DVRNBR'
     */
    const VALUE_DVRNBR = 'DVRNBR';
    /**
     * Constant for value 'RSORNT'
     * @return string 'RSORNT'
     */
    const VALUE_RSORNT = 'RSORNT';
    /**
     * Constant for value 'DEPCOD'
     * @return string 'DEPCOD'
     */
    const VALUE_DEPCOD = 'DEPCOD';
    /**
     * Constant for value 'PRJNBR'
     * @return string 'PRJNBR'
     */
    const VALUE_PRJNBR = 'PRJNBR';
    /**
     * Constant for value 'ACCUNI'
     * @return string 'ACCUNI'
     */
    const VALUE_ACCUNI = 'ACCUNI';
    /**
     * Constant for value 'DEPDAT'
     * @return string 'DEPDAT'
     */
    const VALUE_DEPDAT = 'DEPDAT';
    /**
     * Constant for value 'DESTIN'
     * @return string 'DESTIN'
     */
    const VALUE_DESTIN = 'DESTIN';
    /**
     * Constant for value 'ORDEBY'
     * @return string 'ORDEBY'
     */
    const VALUE_ORDEBY = 'ORDEBY';
    /**
     * Constant for value 'PRVRNT'
     * @return string 'PRVRNT'
     */
    const VALUE_PRVRNT = 'PRVRNT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTCOD
     * @uses self::VALUE_COSCTR
     * @uses self::VALUE_INTACC
     * @uses self::VALUE_CUSREF
     * @uses self::VALUE_ORDNBR
     * @uses self::VALUE_AUTCOD
     * @uses self::VALUE_EMPNBR
     * @uses self::VALUE_DVRNBR
     * @uses self::VALUE_RSORNT
     * @uses self::VALUE_DEPCOD
     * @uses self::VALUE_PRJNBR
     * @uses self::VALUE_ACCUNI
     * @uses self::VALUE_DEPDAT
     * @uses self::VALUE_DESTIN
     * @uses self::VALUE_ORDEBY
     * @uses self::VALUE_PRVRNT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTCOD,
            self::VALUE_COSCTR,
            self::VALUE_INTACC,
            self::VALUE_CUSREF,
            self::VALUE_ORDNBR,
            self::VALUE_AUTCOD,
            self::VALUE_EMPNBR,
            self::VALUE_DVRNBR,
            self::VALUE_RSORNT,
            self::VALUE_DEPCOD,
            self::VALUE_PRJNBR,
            self::VALUE_ACCUNI,
            self::VALUE_DEPDAT,
            self::VALUE_DESTIN,
            self::VALUE_ORDEBY,
            self::VALUE_PRVRNT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
