<?php

namespace GreenwayFirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offhireDetail StructType
 * Meta informations extracted from the WSDL
 * - type: tns:offhireDetail
 * @subpackage Structs
 */
class OffhireDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayFirectService\StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The rentalNumber
     * @var int
     */
    public $rentalNumber;
    /**
     * The end
     * @var \GreenwayFirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $note;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for offhireDetail
     * @uses OffhireDetail::setAuthentication()
     * @uses OffhireDetail::setReservationNumber()
     * @uses OffhireDetail::setRentalNumber()
     * @uses OffhireDetail::setEnd()
     * @uses OffhireDetail::setNote()
     * @uses OffhireDetail::setError()
     * @param \GreenwayFirectService\StructType\AuthenticationType $authentication
     * @param int $reservationNumber
     * @param int $rentalNumber
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $end
     * @param string[] $note
     * @param \GreenwayFirectService\StructType\ErrorType[] $error
     */
    public function __construct(\GreenwayFirectService\StructType\AuthenticationType $authentication = null, $reservationNumber = null, $rentalNumber = null, \GreenwayFirectService\StructType\WhenAndWhereDetails $end = null, array $note = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setRentalNumber($rentalNumber)
            ->setEnd($end)
            ->setNote($note)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayFirectService\StructType\AuthenticationType|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayFirectService\StructType\AuthenticationType $authentication
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function setAuthentication(\GreenwayFirectService\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return int|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param int $rentalNumber
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rentalNumber) && !is_numeric($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayFirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function setEnd(\GreenwayFirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get note value
     * @return string[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param string[] $note
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($note) && strlen($note) > 50) || (is_array($note) && count($note) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($note) ? strlen($note) : count($note)), __LINE__);
        }
        foreach ($note as $offhireDetailNoteItem) {
            // validation for constraint: itemType
            if (!is_string($offhireDetailNoteItem)) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($offhireDetailNoteItem) ? get_class($offhireDetailNoteItem) : gettype($offhireDetailNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function addToNote($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayFirectService\StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ErrorType[] $error
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $offhireDetailErrorItem) {
            // validation for constraint: itemType
            if (!$offhireDetailErrorItem instanceof \GreenwayFirectService\StructType\ErrorType) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayFirectService\StructType\ErrorType, "%s" given', is_object($offhireDetailErrorItem) ? get_class($offhireDetailErrorItem) : gettype($offhireDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ErrorType $item
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public function addToError(\GreenwayFirectService\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayFirectService\StructType\ErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayFirectService\StructType\OffhireDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
