<?php

namespace GreenwayFirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for licenceType StructType
 * Meta informations extracted from the WSDL
 * - type: licenceType
 * @subpackage Structs
 */
class LicenceType extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The issueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $issueDate;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $expiryDate;
    /**
     * The issuingCity
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * @var string
     */
    public $issuingCity;
    /**
     * The issuingCountry
     * Meta informations extracted from the WSDL
     * - length: 2
     * @var string
     */
    public $issuingCountry;
    /**
     * Constructor method for licenceType
     * @uses LicenceType::setNumber()
     * @uses LicenceType::setIssueDate()
     * @uses LicenceType::setExpiryDate()
     * @uses LicenceType::setIssuingCity()
     * @uses LicenceType::setIssuingCountry()
     * @param string $number
     * @param string $issueDate
     * @param string $expiryDate
     * @param string $issuingCity
     * @param string $issuingCountry
     */
    public function __construct($number = null, $issueDate = null, $expiryDate = null, $issuingCity = null, $issuingCountry = null)
    {
        $this
            ->setNumber($number)
            ->setIssueDate($issueDate)
            ->setExpiryDate($expiryDate)
            ->setIssuingCity($issuingCity)
            ->setIssuingCountry($issuingCountry);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \GreenwayFirectService\StructType\LicenceType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \GreenwayFirectService\StructType\LicenceType
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($issueDate) && strlen($issueDate) !== 10) || (is_array($issueDate) && count($issueDate) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($issueDate) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($issueDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \GreenwayFirectService\StructType\LicenceType
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($expiryDate) && strlen($expiryDate) !== 10) || (is_array($expiryDate) && count($expiryDate) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($expiryDate) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($expiryDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get issuingCity value
     * @return string|null
     */
    public function getIssuingCity()
    {
        return $this->issuingCity;
    }
    /**
     * Set issuingCity value
     * @param string $issuingCity
     * @return \GreenwayFirectService\StructType\LicenceType
     */
    public function setIssuingCity($issuingCity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issuingCity) && strlen($issuingCity) > 35) || (is_array($issuingCity) && count($issuingCity) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($issuingCity) ? strlen($issuingCity) : count($issuingCity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuingCity) && !is_string($issuingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuingCity)), __LINE__);
        }
        $this->issuingCity = $issuingCity;
        return $this;
    }
    /**
     * Get issuingCountry value
     * @return string|null
     */
    public function getIssuingCountry()
    {
        return $this->issuingCountry;
    }
    /**
     * Set issuingCountry value
     * @param string $issuingCountry
     * @return \GreenwayFirectService\StructType\LicenceType
     */
    public function setIssuingCountry($issuingCountry = null)
    {
        // validation for constraint: length
        if ((is_scalar($issuingCountry) && strlen($issuingCountry) !== 2) || (is_array($issuingCountry) && count($issuingCountry) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuingCountry) && !is_string($issuingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuingCountry)), __LINE__);
        }
        $this->issuingCountry = $issuingCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayFirectService\StructType\LicenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
