<?php

namespace GreenwayFirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fullRentalDetail StructType
 * @subpackage Structs
 */
class FullRentalDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayFirectService\StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The rentalNumber
     * @var int
     */
    public $rentalNumber;
    /**
     * The rentalUpdateType
     * @var string
     */
    public $rentalUpdateType;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - totalDigits: 8
     * @var int
     */
    public $contractId;
    /**
     * The modelRequested
     * Meta informations extracted from the WSDL
     * - pattern: [A-Z]{4}
     * - type: acrissCode
     * @var string
     */
    public $modelRequested;
    /**
     * The iataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNumber;
    /**
     * The start
     * @var \GreenwayFirectService\StructType\WhenAndWhereDetails
     */
    public $start;
    /**
     * The end
     * @var \GreenwayFirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * @var \GreenwayFirectService\StructType\DriverType[]
     */
    public $driver;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\PaymentType[]
     */
    public $payment;
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 13
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\CustomerReferenceType[]
     */
    public $customerReference;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $note;
    /**
     * The charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\ChargeDetail[]
     */
    public $charges;
    /**
     * The vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \GreenwayFirectService\StructType\VehicleDetail[]
     */
    public $vehicle;
    /**
     * The lastBillingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $lastBillingDate;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayFirectService\StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for fullRentalDetail
     * @uses FullRentalDetail::setAuthentication()
     * @uses FullRentalDetail::setRentalNumber()
     * @uses FullRentalDetail::setRentalUpdateType()
     * @uses FullRentalDetail::setReservationNumber()
     * @uses FullRentalDetail::setContractId()
     * @uses FullRentalDetail::setModelRequested()
     * @uses FullRentalDetail::setIataNumber()
     * @uses FullRentalDetail::setFlightNumber()
     * @uses FullRentalDetail::setStart()
     * @uses FullRentalDetail::setEnd()
     * @uses FullRentalDetail::setDriver()
     * @uses FullRentalDetail::setPayment()
     * @uses FullRentalDetail::setCustomerReference()
     * @uses FullRentalDetail::setNote()
     * @uses FullRentalDetail::setCharges()
     * @uses FullRentalDetail::setVehicle()
     * @uses FullRentalDetail::setLastBillingDate()
     * @uses FullRentalDetail::setError()
     * @param \GreenwayFirectService\StructType\AuthenticationType $authentication
     * @param int $rentalNumber
     * @param string $rentalUpdateType
     * @param int $reservationNumber
     * @param int $contractId
     * @param string $modelRequested
     * @param string $iataNumber
     * @param string $flightNumber
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $start
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $end
     * @param \GreenwayFirectService\StructType\DriverType[] $driver
     * @param \GreenwayFirectService\StructType\PaymentType[] $payment
     * @param \GreenwayFirectService\StructType\CustomerReferenceType[] $customerReference
     * @param string[] $note
     * @param \GreenwayFirectService\StructType\ChargeDetail[] $charges
     * @param \GreenwayFirectService\StructType\VehicleDetail[] $vehicle
     * @param string $lastBillingDate
     * @param \GreenwayFirectService\StructType\ErrorType[] $error
     */
    public function __construct(\GreenwayFirectService\StructType\AuthenticationType $authentication = null, $rentalNumber = null, $rentalUpdateType = null, $reservationNumber = null, $contractId = null, $modelRequested = null, $iataNumber = null, $flightNumber = null, \GreenwayFirectService\StructType\WhenAndWhereDetails $start = null, \GreenwayFirectService\StructType\WhenAndWhereDetails $end = null, array $driver = array(), array $payment = array(), array $customerReference = array(), array $note = array(), array $charges = array(), array $vehicle = array(), $lastBillingDate = null, array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setRentalNumber($rentalNumber)
            ->setRentalUpdateType($rentalUpdateType)
            ->setReservationNumber($reservationNumber)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setCharges($charges)
            ->setVehicle($vehicle)
            ->setLastBillingDate($lastBillingDate)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayFirectService\StructType\AuthenticationType|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayFirectService\StructType\AuthenticationType $authentication
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setAuthentication(\GreenwayFirectService\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return int|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param int $rentalNumber
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rentalNumber) && !is_numeric($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get rentalUpdateType value
     * @return string|null
     */
    public function getRentalUpdateType()
    {
        return $this->rentalUpdateType;
    }
    /**
     * Set rentalUpdateType value
     * @uses \GreenwayFirectService\EnumType\RentalMessageType::valueIsValid()
     * @uses \GreenwayFirectService\EnumType\RentalMessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rentalUpdateType
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setRentalUpdateType($rentalUpdateType = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayFirectService\EnumType\RentalMessageType::valueIsValid($rentalUpdateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rentalUpdateType, implode(', ', \GreenwayFirectService\EnumType\RentalMessageType::getValidValues())), __LINE__);
        }
        $this->rentalUpdateType = $rentalUpdateType;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get contractId value
     * @return int|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param int $contractId
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($contractId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $contractId)) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 8 digits, "%d" given', strlen(substr($contractId, strpos($contractId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($contractId) && !is_numeric($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return string|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param string $modelRequested
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setModelRequested($modelRequested = null)
    {
        // validation for constraint: pattern
        if (is_scalar($modelRequested) && !preg_match('/[A-Z]{4}/', $modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]{4}", "%s" given', var_export($modelRequested, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modelRequested) && !is_string($modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelRequested)), __LINE__);
        }
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get start value
     * @return \GreenwayFirectService\StructType\WhenAndWhereDetails|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $start
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setStart(\GreenwayFirectService\StructType\WhenAndWhereDetails $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayFirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayFirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setEnd(\GreenwayFirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return \GreenwayFirectService\StructType\DriverType[]|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\DriverType[] $driver
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $fullRentalDetailDriverItem) {
            // validation for constraint: itemType
            if (!$fullRentalDetailDriverItem instanceof \GreenwayFirectService\StructType\DriverType) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayFirectService\StructType\DriverType, "%s" given', is_object($fullRentalDetailDriverItem) ? get_class($fullRentalDetailDriverItem) : gettype($fullRentalDetailDriverItem)), __LINE__);
            }
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\DriverType $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToDriver(\GreenwayFirectService\StructType\DriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\DriverType) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayFirectService\StructType\DriverType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Get payment value
     * @return \GreenwayFirectService\StructType\PaymentType[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\PaymentType[] $payment
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $fullRentalDetailPaymentItem) {
            // validation for constraint: itemType
            if (!$fullRentalDetailPaymentItem instanceof \GreenwayFirectService\StructType\PaymentType) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayFirectService\StructType\PaymentType, "%s" given', is_object($fullRentalDetailPaymentItem) ? get_class($fullRentalDetailPaymentItem) : gettype($fullRentalDetailPaymentItem)), __LINE__);
            }
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\PaymentType $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToPayment(\GreenwayFirectService\StructType\PaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\PaymentType) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayFirectService\StructType\PaymentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get customerReference value
     * @return \GreenwayFirectService\StructType\CustomerReferenceType[]|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\CustomerReferenceType[] $customerReference
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setCustomerReference(array $customerReference = array())
    {
        foreach ($customerReference as $fullRentalDetailCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!$fullRentalDetailCustomerReferenceItem instanceof \GreenwayFirectService\StructType\CustomerReferenceType) {
                throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayFirectService\StructType\CustomerReferenceType, "%s" given', is_object($fullRentalDetailCustomerReferenceItem) ? get_class($fullRentalDetailCustomerReferenceItem) : gettype($fullRentalDetailCustomerReferenceItem)), __LINE__);
            }
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\CustomerReferenceType $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToCustomerReference(\GreenwayFirectService\StructType\CustomerReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\CustomerReferenceType) {
            throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayFirectService\StructType\CustomerReferenceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerReference[] = $item;
        return $this;
    }
    /**
     * Get note value
     * @return string[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param string[] $note
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($note) && strlen($note) > 50) || (is_array($note) && count($note) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($note) ? strlen($note) : count($note)), __LINE__);
        }
        foreach ($note as $fullRentalDetailNoteItem) {
            // validation for constraint: itemType
            if (!is_string($fullRentalDetailNoteItem)) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($fullRentalDetailNoteItem) ? get_class($fullRentalDetailNoteItem) : gettype($fullRentalDetailNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToNote($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get charges value
     * @return \GreenwayFirectService\StructType\ChargeDetail[]|null
     */
    public function getCharges()
    {
        return $this->charges;
    }
    /**
     * Set charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ChargeDetail[] $charges
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $fullRentalDetailChargesItem) {
            // validation for constraint: itemType
            if (!$fullRentalDetailChargesItem instanceof \GreenwayFirectService\StructType\ChargeDetail) {
                throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayFirectService\StructType\ChargeDetail, "%s" given', is_object($fullRentalDetailChargesItem) ? get_class($fullRentalDetailChargesItem) : gettype($fullRentalDetailChargesItem)), __LINE__);
            }
        }
        $this->charges = $charges;
        return $this;
    }
    /**
     * Add item to charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ChargeDetail $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToCharges(\GreenwayFirectService\StructType\ChargeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\ChargeDetail) {
            throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayFirectService\StructType\ChargeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charges[] = $item;
        return $this;
    }
    /**
     * Get vehicle value
     * @return \GreenwayFirectService\StructType\VehicleDetail[]|null
     */
    public function getVehicle()
    {
        return $this->vehicle;
    }
    /**
     * Set vehicle value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\VehicleDetail[] $vehicle
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setVehicle(array $vehicle = array())
    {
        foreach ($vehicle as $fullRentalDetailVehicleItem) {
            // validation for constraint: itemType
            if (!$fullRentalDetailVehicleItem instanceof \GreenwayFirectService\StructType\VehicleDetail) {
                throw new \InvalidArgumentException(sprintf('The vehicle property can only contain items of \GreenwayFirectService\StructType\VehicleDetail, "%s" given', is_object($fullRentalDetailVehicleItem) ? get_class($fullRentalDetailVehicleItem) : gettype($fullRentalDetailVehicleItem)), __LINE__);
            }
        }
        $this->vehicle = $vehicle;
        return $this;
    }
    /**
     * Add item to vehicle value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\VehicleDetail $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToVehicle(\GreenwayFirectService\StructType\VehicleDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\VehicleDetail) {
            throw new \InvalidArgumentException(sprintf('The vehicle property can only contain items of \GreenwayFirectService\StructType\VehicleDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vehicle[] = $item;
        return $this;
    }
    /**
     * Get lastBillingDate value
     * @return string|null
     */
    public function getLastBillingDate()
    {
        return $this->lastBillingDate;
    }
    /**
     * Set lastBillingDate value
     * @param string $lastBillingDate
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setLastBillingDate($lastBillingDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($lastBillingDate) && strlen($lastBillingDate) !== 10) || (is_array($lastBillingDate) && count($lastBillingDate) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($lastBillingDate) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $lastBillingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($lastBillingDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastBillingDate) && !is_string($lastBillingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastBillingDate)), __LINE__);
        }
        $this->lastBillingDate = $lastBillingDate;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayFirectService\StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ErrorType[] $error
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $fullRentalDetailErrorItem) {
            // validation for constraint: itemType
            if (!$fullRentalDetailErrorItem instanceof \GreenwayFirectService\StructType\ErrorType) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayFirectService\StructType\ErrorType, "%s" given', is_object($fullRentalDetailErrorItem) ? get_class($fullRentalDetailErrorItem) : gettype($fullRentalDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayFirectService\StructType\ErrorType $item
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public function addToError(\GreenwayFirectService\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayFirectService\StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayFirectService\StructType\ErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayFirectService\StructType\FullRentalDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
