<?php

namespace GreenwayFirectService\EnumType;

/**
 * This class stands for statusCodeType EnumType
 * @subpackage Enumerations
 */
class StatusCodeType
{
    /**
     * Constant for value 'SOLD'
     * @return string 'SOLD'
     */
    const VALUE_SOLD = 'SOLD';
    /**
     * Constant for value 'REQUEST'
     * @return string 'REQUEST'
     */
    const VALUE_REQUEST = 'REQUEST';
    /**
     * Constant for value 'CONFIRMED'
     * @return string 'CONFIRMED'
     */
    const VALUE_CONFIRMED = 'CONFIRMED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOLD
     * @uses self::VALUE_REQUEST
     * @uses self::VALUE_CONFIRMED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOLD,
            self::VALUE_REQUEST,
            self::VALUE_CONFIRMED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
