<?php

namespace GreenwayFirectService;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'phoneNumberType' => '\\GreenwayFirectService\\StructType\\PhoneNumberType',
            'rentalAddressType' => '\\GreenwayFirectService\\StructType\\RentalAddressType',
            'whenAndWhereDetails' => '\\GreenwayFirectService\\StructType\\WhenAndWhereDetails',
            'instructions' => '\\GreenwayFirectService\\StructType\\Instructions',
            'authenticationType' => '\\GreenwayFirectService\\StructType\\AuthenticationType',
            'errorType' => '\\GreenwayFirectService\\StructType\\ErrorType',
            'licenceType' => '\\GreenwayFirectService\\StructType\\LicenceType',
            'driverDetailsType' => '\\GreenwayFirectService\\StructType\\DriverDetailsType',
            'driverType' => '\\GreenwayFirectService\\StructType\\DriverType',
            'cardDetails' => '\\GreenwayFirectService\\StructType\\CardDetails',
            'paymentType' => '\\GreenwayFirectService\\StructType\\PaymentType',
            'customerReferenceType' => '\\GreenwayFirectService\\StructType\\CustomerReferenceType',
            'chargeDetail' => '\\GreenwayFirectService\\StructType\\ChargeDetail',
            'rates' => '\\GreenwayFirectService\\StructType\\Rates',
            'specialCharges' => '\\GreenwayFirectService\\StructType\\SpecialCharges',
            'equipmentDetail' => '\\GreenwayFirectService\\StructType\\EquipmentDetail',
            'vehicleDetail' => '\\GreenwayFirectService\\StructType\\VehicleDetail',
            'reservation' => '\\GreenwayFirectService\\StructType\\Reservation',
            'cancelResDetail' => '\\GreenwayFirectService\\StructType\\CancelResDetail',
            'fullRentalDetail' => '\\GreenwayFirectService\\StructType\\FullRentalDetail',
            'offhireDetail' => '\\GreenwayFirectService\\StructType\\OffhireDetail',
            'amendOffhire' => '\\GreenwayFirectService\\StructType\\AmendOffhire',
            'amendOffhireResponse' => '\\GreenwayFirectService\\StructType\\AmendOffhireResponse',
            'cancelReservation' => '\\GreenwayFirectService\\StructType\\CancelReservation',
            'cancelReservationResponse' => '\\GreenwayFirectService\\StructType\\CancelReservationResponse',
            'amendReservation' => '\\GreenwayFirectService\\StructType\\AmendReservation',
            'amendReservationResponse' => '\\GreenwayFirectService\\StructType\\AmendReservationResponse',
            'newReservation' => '\\GreenwayFirectService\\StructType\\NewReservation',
            'newReservationResponse' => '\\GreenwayFirectService\\StructType\\NewReservationResponse',
            'getQuote' => '\\GreenwayFirectService\\StructType\\GetQuote',
            'checkoutRA' => '\\GreenwayFirectService\\StructType\\CheckoutRA',
            'checkoutRAResponse' => '\\GreenwayFirectService\\StructType\\CheckoutRAResponse',
            'checkinRA' => '\\GreenwayFirectService\\StructType\\CheckinRA',
            'checkinRAResponse' => '\\GreenwayFirectService\\StructType\\CheckinRAResponse',
            'amendRA' => '\\GreenwayFirectService\\StructType\\AmendRA',
            'amendRAResponse' => '\\GreenwayFirectService\\StructType\\AmendRAResponse',
            'cancelRA' => '\\GreenwayFirectService\\StructType\\CancelRA',
            'cancelRAResponse' => '\\GreenwayFirectService\\StructType\\CancelRAResponse',
        );
    }
}
