<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructContactList StructType
 * @subpackage Structs
 */
class StructContactList extends AbstractStructBase
{
    /**
     * The idContact
     * @var string
     */
    public $idContact;
    /**
     * The firstName
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * @var string
     */
    public $lastName;
    /**
     * The bodyForm
     * @var string
     */
    public $bodyForm;
    /**
     * The bodyName
     * @var string
     */
    public $bodyName;
    /**
     * The isOwner
     * @var int
     */
    public $isOwner;
    /**
     * Constructor method for StructContactList
     * @uses StructContactList::setIdContact()
     * @uses StructContactList::setFirstName()
     * @uses StructContactList::setLastName()
     * @uses StructContactList::setBodyForm()
     * @uses StructContactList::setBodyName()
     * @uses StructContactList::setIsOwner()
     * @param string $idContact
     * @param string $firstName
     * @param string $lastName
     * @param string $bodyForm
     * @param string $bodyName
     * @param int $isOwner
     */
    public function __construct($idContact = null, $firstName = null, $lastName = null, $bodyForm = null, $bodyName = null, $isOwner = null)
    {
        $this
            ->setIdContact($idContact)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setBodyForm($bodyForm)
            ->setBodyName($bodyName)
            ->setIsOwner($isOwner);
    }
    /**
     * Get idContact value
     * @return string|null
     */
    public function getIdContact()
    {
        return $this->idContact;
    }
    /**
     * Set idContact value
     * @param string $idContact
     * @return \netim\StructType\StructContactList
     */
    public function setIdContact($idContact = null)
    {
        // validation for constraint: string
        if (!is_null($idContact) && !is_string($idContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idContact)), __LINE__);
        }
        $this->idContact = $idContact;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \netim\StructType\StructContactList
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \netim\StructType\StructContactList
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get bodyForm value
     * @return string|null
     */
    public function getBodyForm()
    {
        return $this->bodyForm;
    }
    /**
     * Set bodyForm value
     * @param string $bodyForm
     * @return \netim\StructType\StructContactList
     */
    public function setBodyForm($bodyForm = null)
    {
        // validation for constraint: string
        if (!is_null($bodyForm) && !is_string($bodyForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bodyForm)), __LINE__);
        }
        $this->bodyForm = $bodyForm;
        return $this;
    }
    /**
     * Get bodyName value
     * @return string|null
     */
    public function getBodyName()
    {
        return $this->bodyName;
    }
    /**
     * Set bodyName value
     * @param string $bodyName
     * @return \netim\StructType\StructContactList
     */
    public function setBodyName($bodyName = null)
    {
        // validation for constraint: string
        if (!is_null($bodyName) && !is_string($bodyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bodyName)), __LINE__);
        }
        $this->bodyName = $bodyName;
        return $this;
    }
    /**
     * Get isOwner value
     * @return int|null
     */
    public function getIsOwner()
    {
        return $this->isOwner;
    }
    /**
     * Set isOwner value
     * @param int $isOwner
     * @return \netim\StructType\StructContactList
     */
    public function setIsOwner($isOwner = null)
    {
        // validation for constraint: int
        if (!is_null($isOwner) && !is_numeric($isOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isOwner)), __LINE__);
        }
        $this->isOwner = $isOwner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructContactList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
