<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Domain ServiceType
 * @subpackage Services
 */
class Domain extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named domainWhois
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return string|bool
     */
    public function domainWhois($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->domainWhois($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructDomainCheckResponse[]|bool
     */
    public function domainCheck($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->domainCheck($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @param string $duration
     * @param string $templateDNS
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainCreate($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $templateDNS)
    {
        try {
            $this->setResult(self::getSoapClient()->domainCreate($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $templateDNS));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainCreateLP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @param string $duration
     * @param string $launchPhase
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainCreateLP($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $launchPhase)
    {
        try {
            $this->setResult(self::getSoapClient()->domainCreateLP($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $launchPhase));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructDomainInfo|bool
     */
    public function domainInfo($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->domainInfo($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTldInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $tld
     * @return \netim\StructType\StructDomainTldInfo|bool
     */
    public function domainTldInfo($iDSession, $tld)
    {
        try {
            $this->setResult(self::getSoapClient()->domainTldInfo($iDSession, $tld));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainPriceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \netim\StructType\StructDomainPriceList[]|bool
     */
    public function domainPriceList($iDSession)
    {
        try {
            $this->setResult(self::getSoapClient()->domainPriceList($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainAuthID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $sendtoregistrant
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainAuthID($iDSession, $domain, $sendtoregistrant)
    {
        try {
            $this->setResult(self::getSoapClient()->domainAuthID($iDSession, $domain, $sendtoregistrant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetMembership
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $token
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainSetMembership($iDSession, $domain, $token)
    {
        try {
            $this->setResult(self::getSoapClient()->domainSetMembership($iDSession, $domain, $token));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainChangeContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainChangeContact($iDSession, $domain, $idAdmin, $idTech, $idBilling)
    {
        try {
            $this->setResult(self::getSoapClient()->domainChangeContact($iDSession, $domain, $idAdmin, $idTech, $idBilling));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainChangeDNS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainChangeDNS($iDSession, $domain, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult(self::getSoapClient()->domainChangeDNS($iDSession, $domain, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetDNSSec
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $enable
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainSetDNSSec($iDSession, $domain, $enable)
    {
        try {
            $this->setResult(self::getSoapClient()->domainSetDNSSec($iDSession, $domain, $enable));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetDNSSecExt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $dSRecords
     * @param string $flags
     * @param string $protocol
     * @param string $algo
     * @param string $pubKey
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainSetDNSSecExt($iDSession, $domain, $dSRecords, $flags, $protocol, $algo, $pubKey)
    {
        try {
            $this->setResult(self::getSoapClient()->domainSetDNSSecExt($iDSession, $domain, $dSRecords, $flags, $protocol, $algo, $pubKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $duration
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainRenew($iDSession, $domain, $duration)
    {
        try {
            $this->setResult(self::getSoapClient()->domainRenew($iDSession, $domain, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainRelease
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainRelease($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->domainRelease($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainRestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainRestore($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->domainRestore($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainInternalTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainInternalTransfer($iDSession, $domain, $authID, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult(self::getSoapClient()->domainInternalTransfer($iDSession, $domain, $authID, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTransferIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainTransferIn($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult(self::getSoapClient()->domainTransferIn($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTransferTrade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainTransferTrade($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult(self::getSoapClient()->domainTransferTrade($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTransferOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idOwner
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainTransferOwner($iDSession, $domain, $idOwner)
    {
        try {
            $this->setResult(self::getSoapClient()->domainTransferOwner($iDSession, $domain, $idOwner));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $codePref
     * @param string $enable
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainSetPreference($iDSession, $domain, $codePref, $enable)
    {
        try {
            $this->setResult(self::getSoapClient()->domainSetPreference($iDSession, $domain, $codePref, $enable));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $typeDelete
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainDelete($iDSession, $domain, $typeDelete)
    {
        try {
            $this->setResult(self::getSoapClient()->domainDelete($iDSession, $domain, $typeDelete));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainMailFwdCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mailBox
     * @param string $recipients
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainMailFwdCreate($iDSession, $mailBox, $recipients)
    {
        try {
            $this->setResult(self::getSoapClient()->domainMailFwdCreate($iDSession, $mailBox, $recipients));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainMailFwdDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mailBox
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainMailFwdDelete($iDSession, $mailBox)
    {
        try {
            $this->setResult(self::getSoapClient()->domainMailFwdDelete($iDSession, $mailBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainWebFwdCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fQDN
     * @param string $target
     * @param string $type
     * @param \netim\StructType\StructOptionsFwd $structOptionsFwd
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainWebFwdCreate($iDSession, $fQDN, $target, $type, \netim\StructType\StructOptionsFwd $structOptionsFwd)
    {
        try {
            $this->setResult(self::getSoapClient()->domainWebFwdCreate($iDSession, $fQDN, $target, $type, $structOptionsFwd));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainWebFwdDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fQDN
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainWebFwdDelete($iDSession, $fQDN)
    {
        try {
            $this->setResult(self::getSoapClient()->domainWebFwdDelete($iDSession, $fQDN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $subdomain
     * @param string $type
     * @param string $value
     * @param \netim\StructType\StructOptionsZone $structOptionsZone
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainZoneCreate($iDSession, $domain, $subdomain, $type, $value, \netim\StructType\StructOptionsZone $structOptionsZone)
    {
        try {
            $this->setResult(self::getSoapClient()->domainZoneCreate($iDSession, $domain, $subdomain, $type, $value, $structOptionsZone));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $subdomain
     * @param string $type
     * @param string $value
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainZoneDelete($iDSession, $domain, $subdomain, $type, $value)
    {
        try {
            $this->setResult(self::getSoapClient()->domainZoneDelete($iDSession, $domain, $subdomain, $type, $value));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneInit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $numTemplate
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainZoneInit($iDSession, $domain, $numTemplate)
    {
        try {
            $this->setResult(self::getSoapClient()->domainZoneInit($iDSession, $domain, $numTemplate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneInitSoa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $ttl
     * @param string $ttlUnity
     * @param string $refresh
     * @param string $refreshUnity
     * @param string $retry
     * @param string $retryUnity
     * @param string $expire
     * @param string $expireUnity
     * @param string $minimum
     * @param string $minimumUnity
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function domainZoneInitSoa($iDSession, $domain, $ttl, $ttlUnity, $refresh, $refreshUnity, $retry, $retryUnity, $expire, $expireUnity, $minimum, $minimumUnity)
    {
        try {
            $this->setResult(self::getSoapClient()->domainZoneInitSoa($iDSession, $domain, $ttl, $ttlUnity, $refresh, $refreshUnity, $retry, $retryUnity, $expire, $expireUnity, $minimum, $minimumUnity));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\netim\StructType\StructDomainCheckResponse[]|\netim\StructType\StructDomainInfo|\netim\StructType\StructDomainPriceList[]|\netim\StructType\StructDomainTldInfo|\netim\StructType\StructOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
