<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api.netim.com/2.0/api.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api.netim.com/2.0/api.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \netim\ClassMap::get(),
);
/**
 * Samples for Session ServiceType
 */
$session = new \netim\ServiceType\Session($options);
/**
 * Sample call for sessionOpen operation/method
 */
if ($session->sessionOpen($idReseller, $password, $language) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
/**
 * Sample call for sessionClose operation/method
 */
if ($session->sessionClose($IDSession) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
/**
 * Sample call for sessionSetPreference operation/method
 */
if ($session->sessionSetPreference($IDSession, $type, $value) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
/**
 * Sample call for sessionInfo operation/method
 */
if ($session->sessionInfo($IDSession) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \netim\ServiceType\Query($options);
/**
 * Sample call for queryAllSessions operation/method
 */
if ($query->queryAllSessions($IDSession) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryOpeList operation/method
 */
if ($query->queryOpeList($IDSession, $ext) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryDomainList operation/method
 */
if ($query->queryDomainList($IDSession, $filter) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryDomainPrice operation/method
 */
if ($query->queryDomainPrice($IDSession, $domain, $authID) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryDomainClaim operation/method
 */
if ($query->queryDomainClaim($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryOpe operation/method
 */
if ($query->queryOpe($IDSession, $numOperation) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryContactList operation/method
 */
if ($query->queryContactList($IDSession, $filter, $field) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryZoneList operation/method
 */
if ($query->queryZoneList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryMailFwdList operation/method
 */
if ($query->queryMailFwdList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryWebFwdList operation/method
 */
if ($query->queryWebFwdList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryHostList operation/method
 */
if ($query->queryHostList($IDSession, $filter) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryResellerAccount operation/method
 */
if ($query->queryResellerAccount($IDSession) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryOpePending operation/method
 */
if ($query->queryOpePending($IDSession) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \netim\ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login($idReseller, $password, $language, $source) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \netim\ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout($IDSession) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Hello ServiceType
 */
$hello = new \netim\ServiceType\Hello($options);
/**
 * Sample call for hello operation/method
 */
if ($hello->hello($IDSession) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Domain ServiceType
 */
$domain = new \netim\ServiceType\Domain($options);
/**
 * Sample call for domainWhois operation/method
 */
if ($domain->domainWhois($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainCheck operation/method
 */
if ($domain->domainCheck($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainCreate operation/method
 */
if ($domain->domainCreate($IDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $templateDNS) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainCreateLP operation/method
 */
if ($domain->domainCreateLP($IDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $launchPhase) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainInfo operation/method
 */
if ($domain->domainInfo($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTldInfo operation/method
 */
if ($domain->domainTldInfo($IDSession, $tld) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainPriceList operation/method
 */
if ($domain->domainPriceList($IDSession) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainAuthID operation/method
 */
if ($domain->domainAuthID($IDSession, $domain, $sendtoregistrant) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetMembership operation/method
 */
if ($domain->domainSetMembership($IDSession, $domain, $token) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainChangeContact operation/method
 */
if ($domain->domainChangeContact($IDSession, $domain, $idAdmin, $idTech, $idBilling) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainChangeDNS operation/method
 */
if ($domain->domainChangeDNS($IDSession, $domain, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetDNSSec operation/method
 */
if ($domain->domainSetDNSSec($IDSession, $domain, $enable) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetDNSSecExt operation/method
 */
if ($domain->domainSetDNSSecExt($IDSession, $domain, $DSRecords, $flags, $protocol, $algo, $pubKey) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainRenew operation/method
 */
if ($domain->domainRenew($IDSession, $domain, $duration) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainRelease operation/method
 */
if ($domain->domainRelease($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainRestore operation/method
 */
if ($domain->domainRestore($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainInternalTransfer operation/method
 */
if ($domain->domainInternalTransfer($IDSession, $domain, $authID, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTransferIn operation/method
 */
if ($domain->domainTransferIn($IDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTransferTrade operation/method
 */
if ($domain->domainTransferTrade($IDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTransferOwner operation/method
 */
if ($domain->domainTransferOwner($IDSession, $domain, $idOwner) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetPreference operation/method
 */
if ($domain->domainSetPreference($IDSession, $domain, $codePref, $enable) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainDelete operation/method
 */
if ($domain->domainDelete($IDSession, $domain, $typeDelete) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainMailFwdCreate operation/method
 */
if ($domain->domainMailFwdCreate($IDSession, $mailBox, $recipients) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainMailFwdDelete operation/method
 */
if ($domain->domainMailFwdDelete($IDSession, $mailBox) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainWebFwdCreate operation/method
 */
if ($domain->domainWebFwdCreate($IDSession, $FQDN, $target, $type, new \netim\StructType\StructOptionsFwd()) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainWebFwdDelete operation/method
 */
if ($domain->domainWebFwdDelete($IDSession, $FQDN) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneCreate operation/method
 */
if ($domain->domainZoneCreate($IDSession, $domain, $subdomain, $type, $value, new \netim\StructType\StructOptionsZone()) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneDelete operation/method
 */
if ($domain->domainZoneDelete($IDSession, $domain, $subdomain, $type, $value) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneInit operation/method
 */
if ($domain->domainZoneInit($IDSession, $domain, $numTemplate) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneInitSoa operation/method
 */
if ($domain->domainZoneInitSoa($IDSession, $domain, $ttl, $ttlUnity, $refresh, $refreshUnity, $retry, $retryUnity, $expire, $expireUnity, $minimum, $minimumUnity) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \netim\ServiceType\Cancel($options);
/**
 * Sample call for cancelOpe operation/method
 */
if ($cancel->cancelOpe($IDSession, $numOperation) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Contact ServiceType
 */
$contact = new \netim\ServiceType\Contact($options);
/**
 * Sample call for contactCreate operation/method
 */
if ($contact->contactCreate($IDSession, new \netim\StructType\StructContact()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactDelete operation/method
 */
if ($contact->contactDelete($IDSession, $idContact) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactInfo operation/method
 */
if ($contact->contactInfo($IDSession, $IDIdentifiant) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactUpdate operation/method
 */
if ($contact->contactUpdate($IDSession, $idContact, new \netim\StructType\StructContact()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactOwnerUpdate operation/method
 */
if ($contact->contactOwnerUpdate($IDSession, $idContact, new \netim\StructType\StructOwnerContact()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Samples for Host ServiceType
 */
$host = new \netim\ServiceType\Host($options);
/**
 * Sample call for hostCreate operation/method
 */
if ($host->hostCreate($IDSession, $host, $ipv4, $ipv6) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Sample call for hostDelete operation/method
 */
if ($host->hostDelete($IDSession, $host) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Sample call for hostUpdate operation/method
 */
if ($host->hostUpdate($IDSession, $host, $ipv4, $ipv6) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Samples for Ssl ServiceType
 */
$ssl = new \netim\ServiceType\Ssl($options);
/**
 * Sample call for sslCreate operation/method
 */
if ($ssl->sslCreate($IDSession, $prod, $duration, new \netim\StructType\StructCSR(), $validation, $IDClient) !== false) {
    print_r($ssl->getResult());
} else {
    print_r($ssl->getLastError());
}
/**
 * Sample call for sslRenew operation/method
 */
if ($ssl->sslRenew($IDSession, $IDSSL, $duration) !== false) {
    print_r($ssl->getResult());
} else {
    print_r($ssl->getLastError());
}
/**
 * Sample call for sslInfo operation/method
 */
if ($ssl->sslInfo($IDSession, $IDSSL) !== false) {
    print_r($ssl->getResult());
} else {
    print_r($ssl->getLastError());
}
/**
 * Sample call for sslReIssue operation/method
 */
if ($ssl->sslReIssue($IDSession, $IDSSL, new \netim\StructType\StructCSR(), $validation) !== false) {
    print_r($ssl->getResult());
} else {
    print_r($ssl->getLastError());
}
/**
 * Sample call for sslRevoke operation/method
 */
if ($ssl->sslRevoke($IDSession, $IDSSL) !== false) {
    print_r($ssl->getResult());
} else {
    print_r($ssl->getLastError());
}
/**
 * Sample call for sslSetPreference operation/method
 */
if ($ssl->sslSetPreference($IDSession, $IDSSL, $codePref, $enable) !== false) {
    print_r($ssl->getResult());
} else {
    print_r($ssl->getLastError());
}
