<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructSSLInfo StructType
 * @subpackage Structs
 */
class StructSSLInfo extends AbstractStructBase
{
    /**
     * The IDSSL
     * @var string
     */
    public $IDSSL;
    /**
     * The prod
     * @var string
     */
    public $prod;
    /**
     * The commonName
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $commonName;
    /**
     * The alternativeNames
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $alternativeNames;
    /**
     * The dateCreation
     * @var string
     */
    public $dateCreation;
    /**
     * The dateEmission
     * @var string
     */
    public $dateEmission;
    /**
     * The dateExpiration
     * @var string
     */
    public $dateExpiration;
    /**
     * The certificate
     * @var string
     */
    public $certificate;
    /**
     * The csr
     * @var string
     */
    public $csr;
    /**
     * The privateKey
     * @var string
     */
    public $privateKey;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for StructSSLInfo
     * @uses StructSSLInfo::setIDSSL()
     * @uses StructSSLInfo::setProd()
     * @uses StructSSLInfo::setCommonName()
     * @uses StructSSLInfo::setAlternativeNames()
     * @uses StructSSLInfo::setDateCreation()
     * @uses StructSSLInfo::setDateEmission()
     * @uses StructSSLInfo::setDateExpiration()
     * @uses StructSSLInfo::setCertificate()
     * @uses StructSSLInfo::setCsr()
     * @uses StructSSLInfo::setPrivateKey()
     * @uses StructSSLInfo::setStatus()
     * @param string $iDSSL
     * @param string $prod
     * @param string[] $commonName
     * @param string[] $alternativeNames
     * @param string $dateCreation
     * @param string $dateEmission
     * @param string $dateExpiration
     * @param string $certificate
     * @param string $csr
     * @param string $privateKey
     * @param string $status
     */
    public function __construct($iDSSL = null, $prod = null, array $commonName = array(), array $alternativeNames = array(), $dateCreation = null, $dateEmission = null, $dateExpiration = null, $certificate = null, $csr = null, $privateKey = null, $status = null)
    {
        $this
            ->setIDSSL($iDSSL)
            ->setProd($prod)
            ->setCommonName($commonName)
            ->setAlternativeNames($alternativeNames)
            ->setDateCreation($dateCreation)
            ->setDateEmission($dateEmission)
            ->setDateExpiration($dateExpiration)
            ->setCertificate($certificate)
            ->setCsr($csr)
            ->setPrivateKey($privateKey)
            ->setStatus($status);
    }
    /**
     * Get IDSSL value
     * @return string|null
     */
    public function getIDSSL()
    {
        return $this->IDSSL;
    }
    /**
     * Set IDSSL value
     * @param string $iDSSL
     * @return \netim\StructType\StructSSLInfo
     */
    public function setIDSSL($iDSSL = null)
    {
        // validation for constraint: string
        if (!is_null($iDSSL) && !is_string($iDSSL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSSL)), __LINE__);
        }
        $this->IDSSL = $iDSSL;
        return $this;
    }
    /**
     * Get prod value
     * @return string|null
     */
    public function getProd()
    {
        return $this->prod;
    }
    /**
     * Set prod value
     * @param string $prod
     * @return \netim\StructType\StructSSLInfo
     */
    public function setProd($prod = null)
    {
        // validation for constraint: string
        if (!is_null($prod) && !is_string($prod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prod)), __LINE__);
        }
        $this->prod = $prod;
        return $this;
    }
    /**
     * Get commonName value
     * @return string[]|null
     */
    public function getCommonName()
    {
        return $this->commonName;
    }
    /**
     * Set commonName value
     * @throws \InvalidArgumentException
     * @param string[] $commonName
     * @return \netim\StructType\StructSSLInfo
     */
    public function setCommonName(array $commonName = array())
    {
        foreach ($commonName as $structSSLInfoCommonNameItem) {
            // validation for constraint: itemType
            if (!is_string($structSSLInfoCommonNameItem)) {
                throw new \InvalidArgumentException(sprintf('The commonName property can only contain items of string, "%s" given', is_object($structSSLInfoCommonNameItem) ? get_class($structSSLInfoCommonNameItem) : gettype($structSSLInfoCommonNameItem)), __LINE__);
            }
        }
        $this->commonName = $commonName;
        return $this;
    }
    /**
     * Add item to commonName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructSSLInfo
     */
    public function addToCommonName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The commonName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->commonName[] = $item;
        return $this;
    }
    /**
     * Get alternativeNames value
     * @return string[]|null
     */
    public function getAlternativeNames()
    {
        return $this->alternativeNames;
    }
    /**
     * Set alternativeNames value
     * @throws \InvalidArgumentException
     * @param string[] $alternativeNames
     * @return \netim\StructType\StructSSLInfo
     */
    public function setAlternativeNames(array $alternativeNames = array())
    {
        foreach ($alternativeNames as $structSSLInfoAlternativeNamesItem) {
            // validation for constraint: itemType
            if (!is_string($structSSLInfoAlternativeNamesItem)) {
                throw new \InvalidArgumentException(sprintf('The alternativeNames property can only contain items of string, "%s" given', is_object($structSSLInfoAlternativeNamesItem) ? get_class($structSSLInfoAlternativeNamesItem) : gettype($structSSLInfoAlternativeNamesItem)), __LINE__);
            }
        }
        $this->alternativeNames = $alternativeNames;
        return $this;
    }
    /**
     * Add item to alternativeNames value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructSSLInfo
     */
    public function addToAlternativeNames($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The alternativeNames property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->alternativeNames[] = $item;
        return $this;
    }
    /**
     * Get dateCreation value
     * @return string|null
     */
    public function getDateCreation()
    {
        return $this->dateCreation;
    }
    /**
     * Set dateCreation value
     * @param string $dateCreation
     * @return \netim\StructType\StructSSLInfo
     */
    public function setDateCreation($dateCreation = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreation) && !is_string($dateCreation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreation)), __LINE__);
        }
        $this->dateCreation = $dateCreation;
        return $this;
    }
    /**
     * Get dateEmission value
     * @return string|null
     */
    public function getDateEmission()
    {
        return $this->dateEmission;
    }
    /**
     * Set dateEmission value
     * @param string $dateEmission
     * @return \netim\StructType\StructSSLInfo
     */
    public function setDateEmission($dateEmission = null)
    {
        // validation for constraint: string
        if (!is_null($dateEmission) && !is_string($dateEmission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEmission)), __LINE__);
        }
        $this->dateEmission = $dateEmission;
        return $this;
    }
    /**
     * Get dateExpiration value
     * @return string|null
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }
    /**
     * Set dateExpiration value
     * @param string $dateExpiration
     * @return \netim\StructType\StructSSLInfo
     */
    public function setDateExpiration($dateExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpiration) && !is_string($dateExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateExpiration)), __LINE__);
        }
        $this->dateExpiration = $dateExpiration;
        return $this;
    }
    /**
     * Get certificate value
     * @return string|null
     */
    public function getCertificate()
    {
        return $this->certificate;
    }
    /**
     * Set certificate value
     * @param string $certificate
     * @return \netim\StructType\StructSSLInfo
     */
    public function setCertificate($certificate = null)
    {
        // validation for constraint: string
        if (!is_null($certificate) && !is_string($certificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certificate)), __LINE__);
        }
        $this->certificate = $certificate;
        return $this;
    }
    /**
     * Get csr value
     * @return string|null
     */
    public function getCsr()
    {
        return $this->csr;
    }
    /**
     * Set csr value
     * @param string $csr
     * @return \netim\StructType\StructSSLInfo
     */
    public function setCsr($csr = null)
    {
        // validation for constraint: string
        if (!is_null($csr) && !is_string($csr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($csr)), __LINE__);
        }
        $this->csr = $csr;
        return $this;
    }
    /**
     * Get privateKey value
     * @return string|null
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }
    /**
     * Set privateKey value
     * @param string $privateKey
     * @return \netim\StructType\StructSSLInfo
     */
    public function setPrivateKey($privateKey = null)
    {
        // validation for constraint: string
        if (!is_null($privateKey) && !is_string($privateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateKey)), __LINE__);
        }
        $this->privateKey = $privateKey;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \netim\StructType\StructSSLInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructSSLInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
