<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostList StructType
 * @subpackage Structs
 */
class StructHostList extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The ipv4
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $ipv4;
    /**
     * The ipv6
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $ipv6;
    /**
     * Constructor method for StructHostList
     * @uses StructHostList::setName()
     * @uses StructHostList::setIpv4()
     * @uses StructHostList::setIpv6()
     * @param string $name
     * @param string[] $ipv4
     * @param string[] $ipv6
     */
    public function __construct($name = null, array $ipv4 = array(), array $ipv6 = array())
    {
        $this
            ->setName($name)
            ->setIpv4($ipv4)
            ->setIpv6($ipv6);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \netim\StructType\StructHostList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipv4 value
     * @return string[]|null
     */
    public function getIpv4()
    {
        return $this->ipv4;
    }
    /**
     * Set ipv4 value
     * @throws \InvalidArgumentException
     * @param string[] $ipv4
     * @return \netim\StructType\StructHostList
     */
    public function setIpv4(array $ipv4 = array())
    {
        foreach ($ipv4 as $structHostListIpv4Item) {
            // validation for constraint: itemType
            if (!is_string($structHostListIpv4Item)) {
                throw new \InvalidArgumentException(sprintf('The ipv4 property can only contain items of string, "%s" given', is_object($structHostListIpv4Item) ? get_class($structHostListIpv4Item) : gettype($structHostListIpv4Item)), __LINE__);
            }
        }
        $this->ipv4 = $ipv4;
        return $this;
    }
    /**
     * Add item to ipv4 value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructHostList
     */
    public function addToIpv4($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ipv4 property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ipv4[] = $item;
        return $this;
    }
    /**
     * Get ipv6 value
     * @return string[]|null
     */
    public function getIpv6()
    {
        return $this->ipv6;
    }
    /**
     * Set ipv6 value
     * @throws \InvalidArgumentException
     * @param string[] $ipv6
     * @return \netim\StructType\StructHostList
     */
    public function setIpv6(array $ipv6 = array())
    {
        foreach ($ipv6 as $structHostListIpv6Item) {
            // validation for constraint: itemType
            if (!is_string($structHostListIpv6Item)) {
                throw new \InvalidArgumentException(sprintf('The ipv6 property can only contain items of string, "%s" given', is_object($structHostListIpv6Item) ? get_class($structHostListIpv6Item) : gettype($structHostListIpv6Item)), __LINE__);
            }
        }
        $this->ipv6 = $ipv6;
        return $this;
    }
    /**
     * Add item to ipv6 value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructHostList
     */
    public function addToIpv6($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ipv6 property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ipv6[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructHostList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
