<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructDomainTldInfo StructType
 * @subpackage Structs
 */
class StructDomainTldInfo extends AbstractStructBase
{
    /**
     * The tld
     * @var string
     */
    public $tld;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - arrayType: typens:StructTld[]
     * - ref: soapenc:arrayType
     * @var \netim\StructType\StructTld[]
     */
    public $Extensions;
    /**
     * The PeriodCreate
     * @var string
     */
    public $PeriodCreate;
    /**
     * The PeriodRenew
     * @var string
     */
    public $PeriodRenew;
    /**
     * The DelaiRenewBeforeExpiration
     * @var int
     */
    public $DelaiRenewBeforeExpiration;
    /**
     * The DelaiRenewAfterExpiration
     * @var int
     */
    public $DelaiRenewAfterExpiration;
    /**
     * The DelaiRestoreAfterDelete
     * @var int
     */
    public $DelaiRestoreAfterDelete;
    /**
     * The HasEppCode
     * @var int
     */
    public $HasEppCode;
    /**
     * The HasRegistrarLock
     * @var int
     */
    public $HasRegistrarLock;
    /**
     * The HasAutorenew
     * @var int
     */
    public $HasAutorenew;
    /**
     * The HasWhoisPrivacy
     * @var int
     */
    public $HasWhoisPrivacy;
    /**
     * The HasMultipleCheck
     * @var int
     */
    public $HasMultipleCheck;
    /**
     * The HasImmediateDelete
     * @var int
     */
    public $HasImmediateDelete;
    /**
     * The HasTrusteeService
     * @var int
     */
    public $HasTrusteeService;
    /**
     * The HasLocalContactService
     * @var int
     */
    public $HasLocalContactService;
    /**
     * The HasZonecheck
     * @var int
     */
    public $HasZonecheck;
    /**
     * The HasDnsSec
     * @var int
     */
    public $HasDnsSec;
    /**
     * The FeeCurrency
     * @var string
     */
    public $FeeCurrency;
    /**
     * The Fee4Registration
     * @var float
     */
    public $Fee4Registration;
    /**
     * The StandardFee4Registration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $StandardFee4Registration;
    /**
     * The RegistrationDiscountEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationDiscountEndDate;
    /**
     * The Fee4Renewal
     * @var float
     */
    public $Fee4Renewal;
    /**
     * The StandardFee4Renewal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $StandardFee4Renewal;
    /**
     * The RenewalDiscountEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RenewalDiscountEndDate;
    /**
     * The Fee4Transfer
     * @var float
     */
    public $Fee4Transfer;
    /**
     * The StandardFee4Transfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $StandardFee4Transfer;
    /**
     * The TransferDiscountEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransferDiscountEndDate;
    /**
     * The Fee4Trade
     * @var float
     */
    public $Fee4Trade;
    /**
     * The Fee4Restore
     * @var float
     */
    public $Fee4Restore;
    /**
     * The Fee4TrusteeService
     * @var float
     */
    public $Fee4TrusteeService;
    /**
     * The Fee4LocalContactService
     * @var float
     */
    public $Fee4LocalContactService;
    /**
     * The Informations
     * @var string
     */
    public $Informations;
    /**
     * Constructor method for StructDomainTldInfo
     * @uses StructDomainTldInfo::setTld()
     * @uses StructDomainTldInfo::setCountry()
     * @uses StructDomainTldInfo::setExtensions()
     * @uses StructDomainTldInfo::setPeriodCreate()
     * @uses StructDomainTldInfo::setPeriodRenew()
     * @uses StructDomainTldInfo::setDelaiRenewBeforeExpiration()
     * @uses StructDomainTldInfo::setDelaiRenewAfterExpiration()
     * @uses StructDomainTldInfo::setDelaiRestoreAfterDelete()
     * @uses StructDomainTldInfo::setHasEppCode()
     * @uses StructDomainTldInfo::setHasRegistrarLock()
     * @uses StructDomainTldInfo::setHasAutorenew()
     * @uses StructDomainTldInfo::setHasWhoisPrivacy()
     * @uses StructDomainTldInfo::setHasMultipleCheck()
     * @uses StructDomainTldInfo::setHasImmediateDelete()
     * @uses StructDomainTldInfo::setHasTrusteeService()
     * @uses StructDomainTldInfo::setHasLocalContactService()
     * @uses StructDomainTldInfo::setHasZonecheck()
     * @uses StructDomainTldInfo::setHasDnsSec()
     * @uses StructDomainTldInfo::setFeeCurrency()
     * @uses StructDomainTldInfo::setFee4Registration()
     * @uses StructDomainTldInfo::setStandardFee4Registration()
     * @uses StructDomainTldInfo::setRegistrationDiscountEndDate()
     * @uses StructDomainTldInfo::setFee4Renewal()
     * @uses StructDomainTldInfo::setStandardFee4Renewal()
     * @uses StructDomainTldInfo::setRenewalDiscountEndDate()
     * @uses StructDomainTldInfo::setFee4Transfer()
     * @uses StructDomainTldInfo::setStandardFee4Transfer()
     * @uses StructDomainTldInfo::setTransferDiscountEndDate()
     * @uses StructDomainTldInfo::setFee4Trade()
     * @uses StructDomainTldInfo::setFee4Restore()
     * @uses StructDomainTldInfo::setFee4TrusteeService()
     * @uses StructDomainTldInfo::setFee4LocalContactService()
     * @uses StructDomainTldInfo::setInformations()
     * @param string $tld
     * @param string $country
     * @param \netim\StructType\StructTld[] $extensions
     * @param string $periodCreate
     * @param string $periodRenew
     * @param int $delaiRenewBeforeExpiration
     * @param int $delaiRenewAfterExpiration
     * @param int $delaiRestoreAfterDelete
     * @param int $hasEppCode
     * @param int $hasRegistrarLock
     * @param int $hasAutorenew
     * @param int $hasWhoisPrivacy
     * @param int $hasMultipleCheck
     * @param int $hasImmediateDelete
     * @param int $hasTrusteeService
     * @param int $hasLocalContactService
     * @param int $hasZonecheck
     * @param int $hasDnsSec
     * @param string $feeCurrency
     * @param float $fee4Registration
     * @param float $standardFee4Registration
     * @param string $registrationDiscountEndDate
     * @param float $fee4Renewal
     * @param float $standardFee4Renewal
     * @param string $renewalDiscountEndDate
     * @param float $fee4Transfer
     * @param float $standardFee4Transfer
     * @param string $transferDiscountEndDate
     * @param float $fee4Trade
     * @param float $fee4Restore
     * @param float $fee4TrusteeService
     * @param float $fee4LocalContactService
     * @param string $informations
     */
    public function __construct($tld = null, $country = null, array $extensions = array(), $periodCreate = null, $periodRenew = null, $delaiRenewBeforeExpiration = null, $delaiRenewAfterExpiration = null, $delaiRestoreAfterDelete = null, $hasEppCode = null, $hasRegistrarLock = null, $hasAutorenew = null, $hasWhoisPrivacy = null, $hasMultipleCheck = null, $hasImmediateDelete = null, $hasTrusteeService = null, $hasLocalContactService = null, $hasZonecheck = null, $hasDnsSec = null, $feeCurrency = null, $fee4Registration = null, $standardFee4Registration = null, $registrationDiscountEndDate = null, $fee4Renewal = null, $standardFee4Renewal = null, $renewalDiscountEndDate = null, $fee4Transfer = null, $standardFee4Transfer = null, $transferDiscountEndDate = null, $fee4Trade = null, $fee4Restore = null, $fee4TrusteeService = null, $fee4LocalContactService = null, $informations = null)
    {
        $this
            ->setTld($tld)
            ->setCountry($country)
            ->setExtensions($extensions)
            ->setPeriodCreate($periodCreate)
            ->setPeriodRenew($periodRenew)
            ->setDelaiRenewBeforeExpiration($delaiRenewBeforeExpiration)
            ->setDelaiRenewAfterExpiration($delaiRenewAfterExpiration)
            ->setDelaiRestoreAfterDelete($delaiRestoreAfterDelete)
            ->setHasEppCode($hasEppCode)
            ->setHasRegistrarLock($hasRegistrarLock)
            ->setHasAutorenew($hasAutorenew)
            ->setHasWhoisPrivacy($hasWhoisPrivacy)
            ->setHasMultipleCheck($hasMultipleCheck)
            ->setHasImmediateDelete($hasImmediateDelete)
            ->setHasTrusteeService($hasTrusteeService)
            ->setHasLocalContactService($hasLocalContactService)
            ->setHasZonecheck($hasZonecheck)
            ->setHasDnsSec($hasDnsSec)
            ->setFeeCurrency($feeCurrency)
            ->setFee4Registration($fee4Registration)
            ->setStandardFee4Registration($standardFee4Registration)
            ->setRegistrationDiscountEndDate($registrationDiscountEndDate)
            ->setFee4Renewal($fee4Renewal)
            ->setStandardFee4Renewal($standardFee4Renewal)
            ->setRenewalDiscountEndDate($renewalDiscountEndDate)
            ->setFee4Transfer($fee4Transfer)
            ->setStandardFee4Transfer($standardFee4Transfer)
            ->setTransferDiscountEndDate($transferDiscountEndDate)
            ->setFee4Trade($fee4Trade)
            ->setFee4Restore($fee4Restore)
            ->setFee4TrusteeService($fee4TrusteeService)
            ->setFee4LocalContactService($fee4LocalContactService)
            ->setInformations($informations);
    }
    /**
     * Get tld value
     * @return string|null
     */
    public function getTld()
    {
        return $this->tld;
    }
    /**
     * Set tld value
     * @param string $tld
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setTld($tld = null)
    {
        // validation for constraint: string
        if (!is_null($tld) && !is_string($tld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tld)), __LINE__);
        }
        $this->tld = $tld;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \netim\StructType\StructTld[]|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @throws \InvalidArgumentException
     * @param \netim\StructType\StructTld[] $extensions
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setExtensions(array $extensions = array())
    {
        foreach ($extensions as $structDomainTldInfoExtensionsItem) {
            // validation for constraint: itemType
            if (!$structDomainTldInfoExtensionsItem instanceof \netim\StructType\StructTld) {
                throw new \InvalidArgumentException(sprintf('The Extensions property can only contain items of \netim\StructType\StructTld, "%s" given', is_object($structDomainTldInfoExtensionsItem) ? get_class($structDomainTldInfoExtensionsItem) : gettype($structDomainTldInfoExtensionsItem)), __LINE__);
            }
        }
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Add item to Extensions value
     * @throws \InvalidArgumentException
     * @param \netim\StructType\StructTld $item
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function addToExtensions(\netim\StructType\StructTld $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \netim\StructType\StructTld) {
            throw new \InvalidArgumentException(sprintf('The Extensions property can only contain items of \netim\StructType\StructTld, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extensions[] = $item;
        return $this;
    }
    /**
     * Get PeriodCreate value
     * @return string|null
     */
    public function getPeriodCreate()
    {
        return $this->PeriodCreate;
    }
    /**
     * Set PeriodCreate value
     * @param string $periodCreate
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setPeriodCreate($periodCreate = null)
    {
        // validation for constraint: string
        if (!is_null($periodCreate) && !is_string($periodCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodCreate)), __LINE__);
        }
        $this->PeriodCreate = $periodCreate;
        return $this;
    }
    /**
     * Get PeriodRenew value
     * @return string|null
     */
    public function getPeriodRenew()
    {
        return $this->PeriodRenew;
    }
    /**
     * Set PeriodRenew value
     * @param string $periodRenew
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setPeriodRenew($periodRenew = null)
    {
        // validation for constraint: string
        if (!is_null($periodRenew) && !is_string($periodRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodRenew)), __LINE__);
        }
        $this->PeriodRenew = $periodRenew;
        return $this;
    }
    /**
     * Get DelaiRenewBeforeExpiration value
     * @return int|null
     */
    public function getDelaiRenewBeforeExpiration()
    {
        return $this->DelaiRenewBeforeExpiration;
    }
    /**
     * Set DelaiRenewBeforeExpiration value
     * @param int $delaiRenewBeforeExpiration
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setDelaiRenewBeforeExpiration($delaiRenewBeforeExpiration = null)
    {
        // validation for constraint: int
        if (!is_null($delaiRenewBeforeExpiration) && !is_numeric($delaiRenewBeforeExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($delaiRenewBeforeExpiration)), __LINE__);
        }
        $this->DelaiRenewBeforeExpiration = $delaiRenewBeforeExpiration;
        return $this;
    }
    /**
     * Get DelaiRenewAfterExpiration value
     * @return int|null
     */
    public function getDelaiRenewAfterExpiration()
    {
        return $this->DelaiRenewAfterExpiration;
    }
    /**
     * Set DelaiRenewAfterExpiration value
     * @param int $delaiRenewAfterExpiration
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setDelaiRenewAfterExpiration($delaiRenewAfterExpiration = null)
    {
        // validation for constraint: int
        if (!is_null($delaiRenewAfterExpiration) && !is_numeric($delaiRenewAfterExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($delaiRenewAfterExpiration)), __LINE__);
        }
        $this->DelaiRenewAfterExpiration = $delaiRenewAfterExpiration;
        return $this;
    }
    /**
     * Get DelaiRestoreAfterDelete value
     * @return int|null
     */
    public function getDelaiRestoreAfterDelete()
    {
        return $this->DelaiRestoreAfterDelete;
    }
    /**
     * Set DelaiRestoreAfterDelete value
     * @param int $delaiRestoreAfterDelete
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setDelaiRestoreAfterDelete($delaiRestoreAfterDelete = null)
    {
        // validation for constraint: int
        if (!is_null($delaiRestoreAfterDelete) && !is_numeric($delaiRestoreAfterDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($delaiRestoreAfterDelete)), __LINE__);
        }
        $this->DelaiRestoreAfterDelete = $delaiRestoreAfterDelete;
        return $this;
    }
    /**
     * Get HasEppCode value
     * @return int|null
     */
    public function getHasEppCode()
    {
        return $this->HasEppCode;
    }
    /**
     * Set HasEppCode value
     * @param int $hasEppCode
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasEppCode($hasEppCode = null)
    {
        // validation for constraint: int
        if (!is_null($hasEppCode) && !is_numeric($hasEppCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasEppCode)), __LINE__);
        }
        $this->HasEppCode = $hasEppCode;
        return $this;
    }
    /**
     * Get HasRegistrarLock value
     * @return int|null
     */
    public function getHasRegistrarLock()
    {
        return $this->HasRegistrarLock;
    }
    /**
     * Set HasRegistrarLock value
     * @param int $hasRegistrarLock
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasRegistrarLock($hasRegistrarLock = null)
    {
        // validation for constraint: int
        if (!is_null($hasRegistrarLock) && !is_numeric($hasRegistrarLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasRegistrarLock)), __LINE__);
        }
        $this->HasRegistrarLock = $hasRegistrarLock;
        return $this;
    }
    /**
     * Get HasAutorenew value
     * @return int|null
     */
    public function getHasAutorenew()
    {
        return $this->HasAutorenew;
    }
    /**
     * Set HasAutorenew value
     * @param int $hasAutorenew
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasAutorenew($hasAutorenew = null)
    {
        // validation for constraint: int
        if (!is_null($hasAutorenew) && !is_numeric($hasAutorenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasAutorenew)), __LINE__);
        }
        $this->HasAutorenew = $hasAutorenew;
        return $this;
    }
    /**
     * Get HasWhoisPrivacy value
     * @return int|null
     */
    public function getHasWhoisPrivacy()
    {
        return $this->HasWhoisPrivacy;
    }
    /**
     * Set HasWhoisPrivacy value
     * @param int $hasWhoisPrivacy
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasWhoisPrivacy($hasWhoisPrivacy = null)
    {
        // validation for constraint: int
        if (!is_null($hasWhoisPrivacy) && !is_numeric($hasWhoisPrivacy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasWhoisPrivacy)), __LINE__);
        }
        $this->HasWhoisPrivacy = $hasWhoisPrivacy;
        return $this;
    }
    /**
     * Get HasMultipleCheck value
     * @return int|null
     */
    public function getHasMultipleCheck()
    {
        return $this->HasMultipleCheck;
    }
    /**
     * Set HasMultipleCheck value
     * @param int $hasMultipleCheck
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasMultipleCheck($hasMultipleCheck = null)
    {
        // validation for constraint: int
        if (!is_null($hasMultipleCheck) && !is_numeric($hasMultipleCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasMultipleCheck)), __LINE__);
        }
        $this->HasMultipleCheck = $hasMultipleCheck;
        return $this;
    }
    /**
     * Get HasImmediateDelete value
     * @return int|null
     */
    public function getHasImmediateDelete()
    {
        return $this->HasImmediateDelete;
    }
    /**
     * Set HasImmediateDelete value
     * @param int $hasImmediateDelete
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasImmediateDelete($hasImmediateDelete = null)
    {
        // validation for constraint: int
        if (!is_null($hasImmediateDelete) && !is_numeric($hasImmediateDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasImmediateDelete)), __LINE__);
        }
        $this->HasImmediateDelete = $hasImmediateDelete;
        return $this;
    }
    /**
     * Get HasTrusteeService value
     * @return int|null
     */
    public function getHasTrusteeService()
    {
        return $this->HasTrusteeService;
    }
    /**
     * Set HasTrusteeService value
     * @param int $hasTrusteeService
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasTrusteeService($hasTrusteeService = null)
    {
        // validation for constraint: int
        if (!is_null($hasTrusteeService) && !is_numeric($hasTrusteeService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasTrusteeService)), __LINE__);
        }
        $this->HasTrusteeService = $hasTrusteeService;
        return $this;
    }
    /**
     * Get HasLocalContactService value
     * @return int|null
     */
    public function getHasLocalContactService()
    {
        return $this->HasLocalContactService;
    }
    /**
     * Set HasLocalContactService value
     * @param int $hasLocalContactService
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasLocalContactService($hasLocalContactService = null)
    {
        // validation for constraint: int
        if (!is_null($hasLocalContactService) && !is_numeric($hasLocalContactService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasLocalContactService)), __LINE__);
        }
        $this->HasLocalContactService = $hasLocalContactService;
        return $this;
    }
    /**
     * Get HasZonecheck value
     * @return int|null
     */
    public function getHasZonecheck()
    {
        return $this->HasZonecheck;
    }
    /**
     * Set HasZonecheck value
     * @param int $hasZonecheck
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasZonecheck($hasZonecheck = null)
    {
        // validation for constraint: int
        if (!is_null($hasZonecheck) && !is_numeric($hasZonecheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasZonecheck)), __LINE__);
        }
        $this->HasZonecheck = $hasZonecheck;
        return $this;
    }
    /**
     * Get HasDnsSec value
     * @return int|null
     */
    public function getHasDnsSec()
    {
        return $this->HasDnsSec;
    }
    /**
     * Set HasDnsSec value
     * @param int $hasDnsSec
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setHasDnsSec($hasDnsSec = null)
    {
        // validation for constraint: int
        if (!is_null($hasDnsSec) && !is_numeric($hasDnsSec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hasDnsSec)), __LINE__);
        }
        $this->HasDnsSec = $hasDnsSec;
        return $this;
    }
    /**
     * Get FeeCurrency value
     * @return string|null
     */
    public function getFeeCurrency()
    {
        return $this->FeeCurrency;
    }
    /**
     * Set FeeCurrency value
     * @param string $feeCurrency
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFeeCurrency($feeCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($feeCurrency) && !is_string($feeCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeCurrency)), __LINE__);
        }
        $this->FeeCurrency = $feeCurrency;
        return $this;
    }
    /**
     * Get Fee4Registration value
     * @return float|null
     */
    public function getFee4Registration()
    {
        return $this->Fee4Registration;
    }
    /**
     * Set Fee4Registration value
     * @param float $fee4Registration
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4Registration($fee4Registration = null)
    {
        $this->Fee4Registration = $fee4Registration;
        return $this;
    }
    /**
     * Get StandardFee4Registration value
     * @return float|null
     */
    public function getStandardFee4Registration()
    {
        return $this->StandardFee4Registration;
    }
    /**
     * Set StandardFee4Registration value
     * @param float $standardFee4Registration
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setStandardFee4Registration($standardFee4Registration = null)
    {
        $this->StandardFee4Registration = $standardFee4Registration;
        return $this;
    }
    /**
     * Get RegistrationDiscountEndDate value
     * @return string|null
     */
    public function getRegistrationDiscountEndDate()
    {
        return $this->RegistrationDiscountEndDate;
    }
    /**
     * Set RegistrationDiscountEndDate value
     * @param string $registrationDiscountEndDate
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setRegistrationDiscountEndDate($registrationDiscountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDiscountEndDate) && !is_string($registrationDiscountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDiscountEndDate)), __LINE__);
        }
        $this->RegistrationDiscountEndDate = $registrationDiscountEndDate;
        return $this;
    }
    /**
     * Get Fee4Renewal value
     * @return float|null
     */
    public function getFee4Renewal()
    {
        return $this->Fee4Renewal;
    }
    /**
     * Set Fee4Renewal value
     * @param float $fee4Renewal
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4Renewal($fee4Renewal = null)
    {
        $this->Fee4Renewal = $fee4Renewal;
        return $this;
    }
    /**
     * Get StandardFee4Renewal value
     * @return float|null
     */
    public function getStandardFee4Renewal()
    {
        return $this->StandardFee4Renewal;
    }
    /**
     * Set StandardFee4Renewal value
     * @param float $standardFee4Renewal
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setStandardFee4Renewal($standardFee4Renewal = null)
    {
        $this->StandardFee4Renewal = $standardFee4Renewal;
        return $this;
    }
    /**
     * Get RenewalDiscountEndDate value
     * @return string|null
     */
    public function getRenewalDiscountEndDate()
    {
        return $this->RenewalDiscountEndDate;
    }
    /**
     * Set RenewalDiscountEndDate value
     * @param string $renewalDiscountEndDate
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setRenewalDiscountEndDate($renewalDiscountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($renewalDiscountEndDate) && !is_string($renewalDiscountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($renewalDiscountEndDate)), __LINE__);
        }
        $this->RenewalDiscountEndDate = $renewalDiscountEndDate;
        return $this;
    }
    /**
     * Get Fee4Transfer value
     * @return float|null
     */
    public function getFee4Transfer()
    {
        return $this->Fee4Transfer;
    }
    /**
     * Set Fee4Transfer value
     * @param float $fee4Transfer
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4Transfer($fee4Transfer = null)
    {
        $this->Fee4Transfer = $fee4Transfer;
        return $this;
    }
    /**
     * Get StandardFee4Transfer value
     * @return float|null
     */
    public function getStandardFee4Transfer()
    {
        return $this->StandardFee4Transfer;
    }
    /**
     * Set StandardFee4Transfer value
     * @param float $standardFee4Transfer
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setStandardFee4Transfer($standardFee4Transfer = null)
    {
        $this->StandardFee4Transfer = $standardFee4Transfer;
        return $this;
    }
    /**
     * Get TransferDiscountEndDate value
     * @return string|null
     */
    public function getTransferDiscountEndDate()
    {
        return $this->TransferDiscountEndDate;
    }
    /**
     * Set TransferDiscountEndDate value
     * @param string $transferDiscountEndDate
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setTransferDiscountEndDate($transferDiscountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($transferDiscountEndDate) && !is_string($transferDiscountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transferDiscountEndDate)), __LINE__);
        }
        $this->TransferDiscountEndDate = $transferDiscountEndDate;
        return $this;
    }
    /**
     * Get Fee4Trade value
     * @return float|null
     */
    public function getFee4Trade()
    {
        return $this->Fee4Trade;
    }
    /**
     * Set Fee4Trade value
     * @param float $fee4Trade
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4Trade($fee4Trade = null)
    {
        $this->Fee4Trade = $fee4Trade;
        return $this;
    }
    /**
     * Get Fee4Restore value
     * @return float|null
     */
    public function getFee4Restore()
    {
        return $this->Fee4Restore;
    }
    /**
     * Set Fee4Restore value
     * @param float $fee4Restore
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4Restore($fee4Restore = null)
    {
        $this->Fee4Restore = $fee4Restore;
        return $this;
    }
    /**
     * Get Fee4TrusteeService value
     * @return float|null
     */
    public function getFee4TrusteeService()
    {
        return $this->Fee4TrusteeService;
    }
    /**
     * Set Fee4TrusteeService value
     * @param float $fee4TrusteeService
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4TrusteeService($fee4TrusteeService = null)
    {
        $this->Fee4TrusteeService = $fee4TrusteeService;
        return $this;
    }
    /**
     * Get Fee4LocalContactService value
     * @return float|null
     */
    public function getFee4LocalContactService()
    {
        return $this->Fee4LocalContactService;
    }
    /**
     * Set Fee4LocalContactService value
     * @param float $fee4LocalContactService
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setFee4LocalContactService($fee4LocalContactService = null)
    {
        $this->Fee4LocalContactService = $fee4LocalContactService;
        return $this;
    }
    /**
     * Get Informations value
     * @return string|null
     */
    public function getInformations()
    {
        return $this->Informations;
    }
    /**
     * Set Informations value
     * @param string $informations
     * @return \netim\StructType\StructDomainTldInfo
     */
    public function setInformations($informations = null)
    {
        // validation for constraint: string
        if (!is_null($informations) && !is_string($informations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informations)), __LINE__);
        }
        $this->Informations = $informations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructDomainTldInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
