<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Session ServiceType
 * @subpackage Services
 */
class Session extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sessionOpen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $idReseller
     * @param string $password
     * @param string $language
     * @return string|bool
     */
    public function sessionOpen($idReseller, $password, $language)
    {
        try {
            $this->setResult(self::getSoapClient()->sessionOpen($idReseller, $password, $language));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sessionClose
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return void|bool
     */
    public function sessionClose($iDSession)
    {
        try {
            $this->setResult(self::getSoapClient()->sessionClose($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sessionSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $type
     * @param string $value
     * @return void|bool
     */
    public function sessionSetPreference($iDSession, $type, $value)
    {
        try {
            $this->setResult(self::getSoapClient()->sessionSetPreference($iDSession, $type, $value));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sessionInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \netim\StructType\StructSessionInfo|bool
     */
    public function sessionInfo($iDSession)
    {
        try {
            $this->setResult(self::getSoapClient()->sessionInfo($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|void|\netim\StructType\StructSessionInfo
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
