<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructOptionsZone StructType
 * @subpackage Structs
 */
class StructOptionsZone extends AbstractStructBase
{
    /**
     * The service
     * @var string
     */
    public $service;
    /**
     * The protocol
     * @var string
     */
    public $protocol;
    /**
     * The ttl
     * @var int
     */
    public $ttl;
    /**
     * The priority
     * @var int
     */
    public $priority;
    /**
     * The weight
     * @var int
     */
    public $weight;
    /**
     * The port
     * @var int
     */
    public $port;
    /**
     * Constructor method for StructOptionsZone
     * @uses StructOptionsZone::setService()
     * @uses StructOptionsZone::setProtocol()
     * @uses StructOptionsZone::setTtl()
     * @uses StructOptionsZone::setPriority()
     * @uses StructOptionsZone::setWeight()
     * @uses StructOptionsZone::setPort()
     * @param string $service
     * @param string $protocol
     * @param int $ttl
     * @param int $priority
     * @param int $weight
     * @param int $port
     */
    public function __construct($service = null, $protocol = null, $ttl = null, $priority = null, $weight = null, $port = null)
    {
        $this
            ->setService($service)
            ->setProtocol($protocol)
            ->setTtl($ttl)
            ->setPriority($priority)
            ->setWeight($weight)
            ->setPort($port);
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \netim\StructType\StructOptionsZone
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \netim\StructType\StructOptionsZone
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get ttl value
     * @return int|null
     */
    public function getTtl()
    {
        return $this->ttl;
    }
    /**
     * Set ttl value
     * @param int $ttl
     * @return \netim\StructType\StructOptionsZone
     */
    public function setTtl($ttl = null)
    {
        // validation for constraint: int
        if (!is_null($ttl) && !is_numeric($ttl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ttl)), __LINE__);
        }
        $this->ttl = $ttl;
        return $this;
    }
    /**
     * Get priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param int $priority
     * @return \netim\StructType\StructOptionsZone
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !is_numeric($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \netim\StructType\StructOptionsZone
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get port value
     * @return int|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param int $port
     * @return \netim\StructType\StructOptionsZone
     */
    public function setPort($port = null)
    {
        // validation for constraint: int
        if (!is_null($port) && !is_numeric($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($port)), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructOptionsZone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
