<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named queryAllSessions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \netim\StructType\StructSessionInfo[]|bool
     */
    public function queryAllSessions($iDSession)
    {
        try {
            $this->setResult(self::getSoapClient()->queryAllSessions($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryOpeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $ext
     * @return \netim\StructType\StructQueryOpeList|bool
     */
    public function queryOpeList($iDSession, $ext)
    {
        try {
            $this->setResult(self::getSoapClient()->queryOpeList($iDSession, $ext));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryDomainList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $filter
     * @return \netim\StructType\StructDomainList[]|bool
     */
    public function queryDomainList($iDSession, $filter)
    {
        try {
            $this->setResult(self::getSoapClient()->queryDomainList($iDSession, $filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryDomainPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @return \netim\StructType\StructQueryDomainPrice|bool
     */
    public function queryDomainPrice($iDSession, $domain, $authID)
    {
        try {
            $this->setResult(self::getSoapClient()->queryDomainPrice($iDSession, $domain, $authID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryDomainClaim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return int|bool
     */
    public function queryDomainClaim($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->queryDomainClaim($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryOpe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $numOperation
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function queryOpe($iDSession, $numOperation)
    {
        try {
            $this->setResult(self::getSoapClient()->queryOpe($iDSession, $numOperation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryContactList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $filter
     * @param string $field
     * @return \netim\StructType\StructContactList[]|bool
     */
    public function queryContactList($iDSession, $filter, $field)
    {
        try {
            $this->setResult(self::getSoapClient()->queryContactList($iDSession, $filter, $field));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryZoneList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructQueryZoneList[]|bool
     */
    public function queryZoneList($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->queryZoneList($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryMailFwdList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructQueryMailFwdList[]|bool
     */
    public function queryMailFwdList($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->queryMailFwdList($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryWebFwdList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructQueryWebFwdList[]|bool
     */
    public function queryWebFwdList($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->queryWebFwdList($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryHostList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $filter
     * @return \netim\StructType\StructHostList[]|bool
     */
    public function queryHostList($iDSession, $filter)
    {
        try {
            $this->setResult(self::getSoapClient()->queryHostList($iDSession, $filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryResellerAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \netim\StructType\StructQueryResellerAccount|bool
     */
    public function queryResellerAccount($iDSession)
    {
        try {
            $this->setResult(self::getSoapClient()->queryResellerAccount($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryOpePending
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \netim\StructType\StructQueryOpePending[]|bool
     */
    public function queryOpePending($iDSession)
    {
        try {
            $this->setResult(self::getSoapClient()->queryOpePending($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|\netim\StructType\StructContactList[]|\netim\StructType\StructDomainList[]|\netim\StructType\StructHostList[]|\netim\StructType\StructOperationResponse|\netim\StructType\StructQueryDomainPrice|\netim\StructType\StructQueryMailFwdList[]|\netim\StructType\StructQueryOpeList|\netim\StructType\StructQueryOpePending[]|\netim\StructType\StructQueryResellerAccount|\netim\StructType\StructQueryWebFwdList[]|\netim\StructType\StructQueryZoneList[]|\netim\StructType\StructSessionInfo[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
