<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contact ServiceType
 * @subpackage Services
 */
class Contact extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named contactCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param \netim\StructType\StructContact $contact
     * @return string|bool
     */
    public function contactCreate($iDSession, \netim\StructType\StructContact $contact)
    {
        try {
            $this->setResult(self::getSoapClient()->contactCreate($iDSession, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $idContact
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function contactDelete($iDSession, $idContact)
    {
        try {
            $this->setResult(self::getSoapClient()->contactDelete($iDSession, $idContact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDIdentifiant
     * @return \netim\StructType\StructContactReturn|bool
     */
    public function contactInfo($iDSession, $iDIdentifiant)
    {
        try {
            $this->setResult(self::getSoapClient()->contactInfo($iDSession, $iDIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $idContact
     * @param \netim\StructType\StructContact $contact
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function contactUpdate($iDSession, $idContact, \netim\StructType\StructContact $contact)
    {
        try {
            $this->setResult(self::getSoapClient()->contactUpdate($iDSession, $idContact, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactOwnerUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $idContact
     * @param \netim\StructType\StructOwnerContact $contact
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function contactOwnerUpdate($iDSession, $idContact, \netim\StructType\StructOwnerContact $contact)
    {
        try {
            $this->setResult(self::getSoapClient()->contactOwnerUpdate($iDSession, $idContact, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\netim\StructType\StructContactReturn|\netim\StructType\StructOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
