<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructTld StructType
 * @subpackage Structs
 */
class StructTld extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The tld
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $tld;
    /**
     * Constructor method for StructTld
     * @uses StructTld::setType()
     * @uses StructTld::setTld()
     * @param string $type
     * @param string[] $tld
     */
    public function __construct($type = null, array $tld = array())
    {
        $this
            ->setType($type)
            ->setTld($tld);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \netim\StructType\StructTld
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get tld value
     * @return string[]|null
     */
    public function getTld()
    {
        return $this->tld;
    }
    /**
     * Set tld value
     * @throws \InvalidArgumentException
     * @param string[] $tld
     * @return \netim\StructType\StructTld
     */
    public function setTld(array $tld = array())
    {
        foreach ($tld as $structTldTldItem) {
            // validation for constraint: itemType
            if (!is_string($structTldTldItem)) {
                throw new \InvalidArgumentException(sprintf('The tld property can only contain items of string, "%s" given', is_object($structTldTldItem) ? get_class($structTldTldItem) : gettype($structTldTldItem)), __LINE__);
            }
        }
        $this->tld = $tld;
        return $this;
    }
    /**
     * Add item to tld value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructTld
     */
    public function addToTld($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tld property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tld[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructTld
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
