<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryZoneList StructType
 * @subpackage Structs
 */
class StructQueryZoneList extends AbstractStructBase
{
    /**
     * The host
     * @var string
     */
    public $host;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The options
     * @var \netim\StructType\StructOptionsZone
     */
    public $options;
    /**
     * Constructor method for StructQueryZoneList
     * @uses StructQueryZoneList::setHost()
     * @uses StructQueryZoneList::setType()
     * @uses StructQueryZoneList::setValue()
     * @uses StructQueryZoneList::setOptions()
     * @param string $host
     * @param string $type
     * @param string $value
     * @param \netim\StructType\StructOptionsZone $options
     */
    public function __construct($host = null, $type = null, $value = null, \netim\StructType\StructOptionsZone $options = null)
    {
        $this
            ->setHost($host)
            ->setType($type)
            ->setValue($value)
            ->setOptions($options);
    }
    /**
     * Get host value
     * @return string|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * Set host value
     * @param string $host
     * @return \netim\StructType\StructQueryZoneList
     */
    public function setHost($host = null)
    {
        // validation for constraint: string
        if (!is_null($host) && !is_string($host)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($host)), __LINE__);
        }
        $this->host = $host;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \netim\StructType\StructQueryZoneList
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \netim\StructType\StructQueryZoneList
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get options value
     * @return \netim\StructType\StructOptionsZone|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \netim\StructType\StructOptionsZone $options
     * @return \netim\StructType\StructQueryZoneList
     */
    public function setOptions(\netim\StructType\StructOptionsZone $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryZoneList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
