<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructCSR StructType
 * @subpackage Structs
 */
class StructCSR extends AbstractStructBase
{
    /**
     * The CSR
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSR;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Department;
    /**
     * The Organisation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Organisation;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The CommonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $CommonName;
    /**
     * The AlternativeNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $AlternativeNames;
    /**
     * Constructor method for StructCSR
     * @uses StructCSR::setCSR()
     * @uses StructCSR::setCountry()
     * @uses StructCSR::setCity()
     * @uses StructCSR::setRegion()
     * @uses StructCSR::setDepartment()
     * @uses StructCSR::setOrganisation()
     * @uses StructCSR::setEmailAddress()
     * @uses StructCSR::setCommonName()
     * @uses StructCSR::setAlternativeNames()
     * @param string $cSR
     * @param string $country
     * @param string $city
     * @param string $region
     * @param string $department
     * @param string $organisation
     * @param string $emailAddress
     * @param string[] $commonName
     * @param string[] $alternativeNames
     */
    public function __construct($cSR = null, $country = null, $city = null, $region = null, $department = null, $organisation = null, $emailAddress = null, array $commonName = array(), array $alternativeNames = array())
    {
        $this
            ->setCSR($cSR)
            ->setCountry($country)
            ->setCity($city)
            ->setRegion($region)
            ->setDepartment($department)
            ->setOrganisation($organisation)
            ->setEmailAddress($emailAddress)
            ->setCommonName($commonName)
            ->setAlternativeNames($alternativeNames);
    }
    /**
     * Get CSR value
     * @return string|null
     */
    public function getCSR()
    {
        return $this->CSR;
    }
    /**
     * Set CSR value
     * @param string $cSR
     * @return \netim\StructType\StructCSR
     */
    public function setCSR($cSR = null)
    {
        // validation for constraint: string
        if (!is_null($cSR) && !is_string($cSR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSR)), __LINE__);
        }
        $this->CSR = $cSR;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \netim\StructType\StructCSR
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \netim\StructType\StructCSR
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \netim\StructType\StructCSR
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \netim\StructType\StructCSR
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Get Organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->Organisation;
    }
    /**
     * Set Organisation value
     * @param string $organisation
     * @return \netim\StructType\StructCSR
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisation)), __LINE__);
        }
        $this->Organisation = $organisation;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \netim\StructType\StructCSR
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CommonName value
     * @return string[]|null
     */
    public function getCommonName()
    {
        return $this->CommonName;
    }
    /**
     * Set CommonName value
     * @throws \InvalidArgumentException
     * @param string[] $commonName
     * @return \netim\StructType\StructCSR
     */
    public function setCommonName(array $commonName = array())
    {
        foreach ($commonName as $structCSRCommonNameItem) {
            // validation for constraint: itemType
            if (!is_string($structCSRCommonNameItem)) {
                throw new \InvalidArgumentException(sprintf('The CommonName property can only contain items of string, "%s" given', is_object($structCSRCommonNameItem) ? get_class($structCSRCommonNameItem) : gettype($structCSRCommonNameItem)), __LINE__);
            }
        }
        $this->CommonName = $commonName;
        return $this;
    }
    /**
     * Add item to CommonName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructCSR
     */
    public function addToCommonName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CommonName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommonName[] = $item;
        return $this;
    }
    /**
     * Get AlternativeNames value
     * @return string[]|null
     */
    public function getAlternativeNames()
    {
        return $this->AlternativeNames;
    }
    /**
     * Set AlternativeNames value
     * @throws \InvalidArgumentException
     * @param string[] $alternativeNames
     * @return \netim\StructType\StructCSR
     */
    public function setAlternativeNames(array $alternativeNames = array())
    {
        foreach ($alternativeNames as $structCSRAlternativeNamesItem) {
            // validation for constraint: itemType
            if (!is_string($structCSRAlternativeNamesItem)) {
                throw new \InvalidArgumentException(sprintf('The AlternativeNames property can only contain items of string, "%s" given', is_object($structCSRAlternativeNamesItem) ? get_class($structCSRAlternativeNamesItem) : gettype($structCSRAlternativeNamesItem)), __LINE__);
            }
        }
        $this->AlternativeNames = $alternativeNames;
        return $this;
    }
    /**
     * Add item to AlternativeNames value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructCSR
     */
    public function addToAlternativeNames($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AlternativeNames property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AlternativeNames[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructCSR
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
