<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ssl ServiceType
 * @subpackage Services
 */
class Ssl extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sslCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $prod
     * @param string $duration
     * @param \netim\StructType\StructCSR $cSRInfo
     * @param string $validation
     * @param string $iDClient
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function sslCreate($iDSession, $prod, $duration, \netim\StructType\StructCSR $cSRInfo, $validation, $iDClient)
    {
        try {
            $this->setResult(self::getSoapClient()->sslCreate($iDSession, $prod, $duration, $cSRInfo, $validation, $iDClient));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sslRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDSSL
     * @param string $duration
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function sslRenew($iDSession, $iDSSL, $duration)
    {
        try {
            $this->setResult(self::getSoapClient()->sslRenew($iDSession, $iDSSL, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sslInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDSSL
     * @return \netim\StructType\StructSSLInfo|bool
     */
    public function sslInfo($iDSession, $iDSSL)
    {
        try {
            $this->setResult(self::getSoapClient()->sslInfo($iDSession, $iDSSL));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sslReIssue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDSSL
     * @param \netim\StructType\StructCSR $cSRInfo
     * @param string $validation
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function sslReIssue($iDSession, $iDSSL, \netim\StructType\StructCSR $cSRInfo, $validation)
    {
        try {
            $this->setResult(self::getSoapClient()->sslReIssue($iDSession, $iDSSL, $cSRInfo, $validation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sslRevoke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDSSL
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function sslRevoke($iDSession, $iDSSL)
    {
        try {
            $this->setResult(self::getSoapClient()->sslRevoke($iDSession, $iDSSL));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sslSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDSSL
     * @param string $codePref
     * @param string $enable
     * @return \netim\StructType\StructOperationResponse|bool
     */
    public function sslSetPreference($iDSession, $iDSSL, $codePref, $enable)
    {
        try {
            $this->setResult(self::getSoapClient()->sslSetPreference($iDSession, $iDSSL, $codePref, $enable));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \netim\StructType\StructOperationResponse|\netim\StructType\StructSSLInfo
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
