<?php

namespace netim\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKeyValueData ArrayType
 * @subpackage Arrays
 */
class ArrayOfKeyValueData extends AbstractStructArrayBase
{
    /**
     * The keyval
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $keyval;
    /**
     * Constructor method for ArrayOfKeyValueData
     * @uses ArrayOfKeyValueData::setKeyval()
     * @param mixed[] $keyval
     */
    public function __construct(array $keyval = array())
    {
        $this
            ->setKeyval($keyval);
    }
    /**
     * Get keyval value
     * @return mixed[]|null
     */
    public function getKeyval()
    {
        return $this->keyval;
    }
    /**
     * Set keyval value
     * @throws \InvalidArgumentException
     * @param mixed[] $keyval
     * @return \netim\ArrayType\ArrayOfKeyValueData
     */
    public function setKeyval(array $keyval = array())
    {
        foreach ($keyval as $arrayOfKeyValueDataKeyvalItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The keyval property can only contain items of anyType, "%s" given', is_object($arrayOfKeyValueDataKeyvalItem) ? get_class($arrayOfKeyValueDataKeyvalItem) : gettype($arrayOfKeyValueDataKeyvalItem)), __LINE__);
            }
        }
        $this->keyval = $keyval;
        return $this;
    }
    /**
     * Add item to keyval value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \netim\ArrayType\ArrayOfKeyValueData
     */
    public function addToKeyval($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The keyval property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->keyval[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return mixed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return mixed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return mixed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return mixed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string keyval
     */
    public function getAttributeName()
    {
        return 'keyval';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \netim\ArrayType\ArrayOfKeyValueData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
