<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitialRequest StructType
 * @subpackage Structs
 */
class InitialRequest extends AbstractStructBase
{
    /**
     * The PdfDocument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Pdfbinary
     */
    public $PdfDocument;
    /**
     * The DistributionList
     * @var \StructType\DistributionList
     */
    public $DistributionList;
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - documentation: Request id
     * - maxLength: 13
     * - pattern: ^[0-9]\-[0-9]\-[0-9]$
     * @var string
     */
    public $RequestId;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * @var string
     */
    public $Description;
    /**
     * The Requestor
     * @var \StructType\Requestor
     */
    public $Requestor;
    /**
     * The InitiativeManager
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * @var string
     */
    public $InitiativeManager;
    /**
     * The RequestDT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 8
     * - pattern: ^[0-9]$
     * @var string
     */
    public $RequestDT;
    /**
     * The FlagNaa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * - pattern: 1}$
     * @var string
     */
    public $FlagNaa;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - length: 2
     * - pattern: ^[0-9]$
     * @var string
     */
    public $Category;
    /**
     * The Opportunity
     * @var \StructType\Opportunityitems
     */
    public $Opportunity;
    /**
     * The VolumeType
     * Meta informations extracted from the WSDL
     * - length: 1
     * - pattern: ^[RF]{1}$
     * @var string
     */
    public $VolumeType;
    /**
     * The EndDT
     * Meta informations extracted from the WSDL
     * - length: 8
     * - pattern: ^[0-9]$
     * @var string
     */
    public $EndDT;
    /**
     * The StartDT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 8
     * - pattern: ^[0-9]$
     * @var string
     */
    public $StartDT;
    /**
     * The TotMsu
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * - pattern: ^[+-]?([0-9]*[.])?[0-9]+$
     * @var string
     */
    public $TotMsu;
    /**
     * The FlagAsForDemand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * - pattern: 1}$
     * @var string
     */
    public $FlagAsForDemand;
    /**
     * The NumProducts
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * - pattern: ^[+-]?([0-9]*[.])?[0-9]+$
     * @var string
     */
    public $NumProducts;
    /**
     * The Products
     * @var \StructType\Productitems
     */
    public $Products;
    /**
     * Constructor method for InitialRequest
     * @uses InitialRequest::setPdfDocument()
     * @uses InitialRequest::setDistributionList()
     * @uses InitialRequest::setRequestId()
     * @uses InitialRequest::setDescription()
     * @uses InitialRequest::setRequestor()
     * @uses InitialRequest::setInitiativeManager()
     * @uses InitialRequest::setRequestDT()
     * @uses InitialRequest::setFlagNaa()
     * @uses InitialRequest::setCategory()
     * @uses InitialRequest::setOpportunity()
     * @uses InitialRequest::setVolumeType()
     * @uses InitialRequest::setEndDT()
     * @uses InitialRequest::setStartDT()
     * @uses InitialRequest::setTotMsu()
     * @uses InitialRequest::setFlagAsForDemand()
     * @uses InitialRequest::setNumProducts()
     * @uses InitialRequest::setProducts()
     * @param \StructType\Pdfbinary $pdfDocument
     * @param \StructType\DistributionList $distributionList
     * @param string $requestId
     * @param string $description
     * @param \StructType\Requestor $requestor
     * @param string $initiativeManager
     * @param string $requestDT
     * @param string $flagNaa
     * @param string $category
     * @param \StructType\Opportunityitems $opportunity
     * @param string $volumeType
     * @param string $endDT
     * @param string $startDT
     * @param string $totMsu
     * @param string $flagAsForDemand
     * @param string $numProducts
     * @param \StructType\Productitems $products
     */
    public function __construct(\StructType\Pdfbinary $pdfDocument = null, \StructType\DistributionList $distributionList = null, $requestId = null, $description = null, \StructType\Requestor $requestor = null, $initiativeManager = null, $requestDT = null, $flagNaa = null, $category = null, \StructType\Opportunityitems $opportunity = null, $volumeType = null, $endDT = null, $startDT = null, $totMsu = null, $flagAsForDemand = null, $numProducts = null, \StructType\Productitems $products = null)
    {
        $this
            ->setPdfDocument($pdfDocument)
            ->setDistributionList($distributionList)
            ->setRequestId($requestId)
            ->setDescription($description)
            ->setRequestor($requestor)
            ->setInitiativeManager($initiativeManager)
            ->setRequestDT($requestDT)
            ->setFlagNaa($flagNaa)
            ->setCategory($category)
            ->setOpportunity($opportunity)
            ->setVolumeType($volumeType)
            ->setEndDT($endDT)
            ->setStartDT($startDT)
            ->setTotMsu($totMsu)
            ->setFlagAsForDemand($flagAsForDemand)
            ->setNumProducts($numProducts)
            ->setProducts($products);
    }
    /**
     * Get PdfDocument value
     * @return \StructType\Pdfbinary|null
     */
    public function getPdfDocument()
    {
        return $this->PdfDocument;
    }
    /**
     * Set PdfDocument value
     * @param \StructType\Pdfbinary $pdfDocument
     * @return \StructType\InitialRequest
     */
    public function setPdfDocument(\StructType\Pdfbinary $pdfDocument = null)
    {
        $this->PdfDocument = $pdfDocument;
        return $this;
    }
    /**
     * Get DistributionList value
     * @return \StructType\DistributionList|null
     */
    public function getDistributionList()
    {
        return $this->DistributionList;
    }
    /**
     * Set DistributionList value
     * @param \StructType\DistributionList $distributionList
     * @return \StructType\InitialRequest
     */
    public function setDistributionList(\StructType\DistributionList $distributionList = null)
    {
        $this->DistributionList = $distributionList;
        return $this;
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\InitialRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestId) && strlen($requestId) > 13) || (is_array($requestId) && count($requestId) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($requestId) ? strlen($requestId) : count($requestId)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($requestId) && !preg_match('/^[0-9]\-[0-9]\-[0-9]$/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]\-[0-9]\-[0-9]$", "%s" given', var_export($requestId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\InitialRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Requestor value
     * @return \StructType\Requestor|null
     */
    public function getRequestor()
    {
        return $this->Requestor;
    }
    /**
     * Set Requestor value
     * @param \StructType\Requestor $requestor
     * @return \StructType\InitialRequest
     */
    public function setRequestor(\StructType\Requestor $requestor = null)
    {
        $this->Requestor = $requestor;
        return $this;
    }
    /**
     * Get InitiativeManager value
     * @return string|null
     */
    public function getInitiativeManager()
    {
        return $this->InitiativeManager;
    }
    /**
     * Set InitiativeManager value
     * @param string $initiativeManager
     * @return \StructType\InitialRequest
     */
    public function setInitiativeManager($initiativeManager = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($initiativeManager) && strlen($initiativeManager) > 255) || (is_array($initiativeManager) && count($initiativeManager) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($initiativeManager) ? strlen($initiativeManager) : count($initiativeManager)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($initiativeManager) && !is_string($initiativeManager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initiativeManager)), __LINE__);
        }
        $this->InitiativeManager = $initiativeManager;
        return $this;
    }
    /**
     * Get RequestDT value
     * @return string|null
     */
    public function getRequestDT()
    {
        return $this->RequestDT;
    }
    /**
     * Set RequestDT value
     * @param string $requestDT
     * @return \StructType\InitialRequest
     */
    public function setRequestDT($requestDT = null)
    {
        // validation for constraint: length
        if ((is_scalar($requestDT) && strlen($requestDT) !== 8) || (is_array($requestDT) && count($requestDT) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($requestDT) && !preg_match('/^[0-9]$/', $requestDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($requestDT, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestDT) && !is_string($requestDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestDT)), __LINE__);
        }
        $this->RequestDT = $requestDT;
        return $this;
    }
    /**
     * Get FlagNaa value
     * @return string|null
     */
    public function getFlagNaa()
    {
        return $this->FlagNaa;
    }
    /**
     * Set FlagNaa value
     * @param string $flagNaa
     * @return \StructType\InitialRequest
     */
    public function setFlagNaa($flagNaa = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($flagNaa) && strlen($flagNaa) > 1) || (is_array($flagNaa) && count($flagNaa) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($flagNaa) ? strlen($flagNaa) : count($flagNaa)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($flagNaa) && !preg_match('/1}$/', $flagNaa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "1}$", "%s" given', var_export($flagNaa, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flagNaa) && !is_string($flagNaa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flagNaa)), __LINE__);
        }
        $this->FlagNaa = $flagNaa;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\InitialRequest
     */
    public function setCategory($category = null)
    {
        // validation for constraint: length
        if ((is_scalar($category) && strlen($category) !== 2) || (is_array($category) && count($category) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($category) && !preg_match('/^[0-9]$/', $category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($category, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Opportunity value
     * @return \StructType\Opportunityitems|null
     */
    public function getOpportunity()
    {
        return $this->Opportunity;
    }
    /**
     * Set Opportunity value
     * @param \StructType\Opportunityitems $opportunity
     * @return \StructType\InitialRequest
     */
    public function setOpportunity(\StructType\Opportunityitems $opportunity = null)
    {
        $this->Opportunity = $opportunity;
        return $this;
    }
    /**
     * Get VolumeType value
     * @return string|null
     */
    public function getVolumeType()
    {
        return $this->VolumeType;
    }
    /**
     * Set VolumeType value
     * @param string $volumeType
     * @return \StructType\InitialRequest
     */
    public function setVolumeType($volumeType = null)
    {
        // validation for constraint: length
        if ((is_scalar($volumeType) && strlen($volumeType) !== 1) || (is_array($volumeType) && count($volumeType) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($volumeType) && !preg_match('/^[RF]{1}$/', $volumeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[RF]{1}$", "%s" given', var_export($volumeType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($volumeType) && !is_string($volumeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($volumeType)), __LINE__);
        }
        $this->VolumeType = $volumeType;
        return $this;
    }
    /**
     * Get EndDT value
     * @return string|null
     */
    public function getEndDT()
    {
        return $this->EndDT;
    }
    /**
     * Set EndDT value
     * @param string $endDT
     * @return \StructType\InitialRequest
     */
    public function setEndDT($endDT = null)
    {
        // validation for constraint: length
        if ((is_scalar($endDT) && strlen($endDT) !== 8) || (is_array($endDT) && count($endDT) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($endDT) && !preg_match('/^[0-9]$/', $endDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($endDT, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDT) && !is_string($endDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDT)), __LINE__);
        }
        $this->EndDT = $endDT;
        return $this;
    }
    /**
     * Get StartDT value
     * @return string|null
     */
    public function getStartDT()
    {
        return $this->StartDT;
    }
    /**
     * Set StartDT value
     * @param string $startDT
     * @return \StructType\InitialRequest
     */
    public function setStartDT($startDT = null)
    {
        // validation for constraint: length
        if ((is_scalar($startDT) && strlen($startDT) !== 8) || (is_array($startDT) && count($startDT) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($startDT) && !preg_match('/^[0-9]$/', $startDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($startDT, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDT) && !is_string($startDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDT)), __LINE__);
        }
        $this->StartDT = $startDT;
        return $this;
    }
    /**
     * Get TotMsu value
     * @return string|null
     */
    public function getTotMsu()
    {
        return $this->TotMsu;
    }
    /**
     * Set TotMsu value
     * @param string $totMsu
     * @return \StructType\InitialRequest
     */
    public function setTotMsu($totMsu = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($totMsu) && strlen($totMsu) > 15) || (is_array($totMsu) && count($totMsu) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($totMsu) ? strlen($totMsu) : count($totMsu)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($totMsu) && !preg_match('/^[+-]?([0-9]*[.])?[0-9]+$/', $totMsu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[+-]?([0-9]*[.])?[0-9]+$", "%s" given', var_export($totMsu, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($totMsu) && !is_string($totMsu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totMsu)), __LINE__);
        }
        $this->TotMsu = $totMsu;
        return $this;
    }
    /**
     * Get FlagAsForDemand value
     * @return string|null
     */
    public function getFlagAsForDemand()
    {
        return $this->FlagAsForDemand;
    }
    /**
     * Set FlagAsForDemand value
     * @param string $flagAsForDemand
     * @return \StructType\InitialRequest
     */
    public function setFlagAsForDemand($flagAsForDemand = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($flagAsForDemand) && strlen($flagAsForDemand) > 1) || (is_array($flagAsForDemand) && count($flagAsForDemand) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($flagAsForDemand) ? strlen($flagAsForDemand) : count($flagAsForDemand)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($flagAsForDemand) && !preg_match('/1}$/', $flagAsForDemand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "1}$", "%s" given', var_export($flagAsForDemand, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flagAsForDemand) && !is_string($flagAsForDemand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flagAsForDemand)), __LINE__);
        }
        $this->FlagAsForDemand = $flagAsForDemand;
        return $this;
    }
    /**
     * Get NumProducts value
     * @return string|null
     */
    public function getNumProducts()
    {
        return $this->NumProducts;
    }
    /**
     * Set NumProducts value
     * @param string $numProducts
     * @return \StructType\InitialRequest
     */
    public function setNumProducts($numProducts = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numProducts) && strlen($numProducts) > 15) || (is_array($numProducts) && count($numProducts) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($numProducts) ? strlen($numProducts) : count($numProducts)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($numProducts) && !preg_match('/^[+-]?([0-9]*[.])?[0-9]+$/', $numProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[+-]?([0-9]*[.])?[0-9]+$", "%s" given', var_export($numProducts, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numProducts) && !is_string($numProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numProducts)), __LINE__);
        }
        $this->NumProducts = $numProducts;
        return $this;
    }
    /**
     * Get Products value
     * @return \StructType\Productitems|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \StructType\Productitems $products
     * @return \StructType\InitialRequest
     */
    public function setProducts(\StructType\Productitems $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
