<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnPolicyType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type used to express the details of the return policy for an item.
 * @subpackage Structs
 */
class ReturnPolicyType extends AbstractStructBase
{
    /**
     * The RefundOption
     * Meta informations extracted from the WSDL
     * - documentation: Indicates how the seller will compensate the buyer for a returned item. Use the <b>ReturnPolicy.Description</b> field to explain the policy details (such as how quickly the seller will process the refund, whether the seller must
     * receive the item before processing the refund, and other useful details.).<br> <br> The <b>RefundOption</b> field is not supported by any of the European sites. <br> <br> <b>Applicable values:</b> To get the applicable <b>RefundOption</b> values for
     * your site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>, and then look for the <b>ReturnPolicyDetails.Refund.RefundOption</b> fields in the response. <br> <br> <b>For Add/Revise/Relist/VerifyAdd API calls):</b>
     * If the seller accepts returns (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but you do not pass in this <b>RefundOption</b> field when listing the item, some eBay sites may set a default value (like <code>MoneyBack</code>), and the
     * seller is obligated to honor this setting. Therefore, to avoid unexpected obligations, the seller should set a specific value for this field.<br> <br> <b>For Revise calls only:</b> If the listing has bids or sales and/or ends within 12 hours, you
     * can't change this value. See the parent <b>ReturnPolicy</b> node description for more details. <br/><br/> <span class="tablenote"><b>Note:</b> The <b>RefundOption</b> values supported on the US site are <code>MoneyBack</code> and
     * <code>MoneyBackOrReplacement</code>. If a seller has the depth of inventory to support an exchange for an identical item, <code>MoneyBackOrReplacement</code> can be used. A seller with limited inventory of an item should use the <b>MoneyBack</b>
     * option. </span>
     * - minOccurs: 0
     * @var string
     */
    public $RefundOption;
    /**
     * The Refund
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <b>RefundOption</b> in a more user-friendly format to buyers. For example, in <b>GetItem</b> and related calls, this value is usually localized and can contain spaces. If
     * necessary, you can predict the choice of values based on the <b>Refund.Description</b> options returned by <b>GeteBayDetails</b>.<br> <br> Not applicable as input to the <b>Add</b>/<b>Revise</b>/<b>Relist</b> family of calls. (Use <b>RefundOption</b>
     * instead.)
     * - minOccurs: 0
     * @var string
     */
    public $Refund;
    /**
     * The ReturnsWithinOption
     * Meta informations extracted from the WSDL
     * - documentation: The buyer can return the item within this period of time from the day they receive the item. Use the <b>ReturnPolicy.Description</b> field to explain the policy details.<br> <br> <b>Applicable values:</b> To get the applicable
     * <b>ReturnsWithinOption</b> values for your site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>, and then look for the <b>ReturnPolicyDetails.ReturnsWithin.ReturnsWithinOption</b> fields in the response.
     * <b>ReturnsWithinOptionsCodeType</b> defines all the possible values.<br> <br> <b>For AddItem, VerifyAddItem, and RelistItem:</b> If the seller accepts returns (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but you do not pass in this
     * <b>ReturnsWithinOption</b> field when listing the item, some eBay sites may set a default value (like Days_14), and the seller is obligated to honor this setting. Therefore, to avoid unexpected obligations, the seller should set a specific value for
     * this field. <br/> <br/> <b>For ReviseItem only:</b> If the listing has bids or sales and/or ends within 12 hours, you can't change this value. See the parent <b>ReturnPolicy</b> node description for more details.
     * - minOccurs: 0
     * @var string
     */
    public $ReturnsWithinOption;
    /**
     * The ReturnsWithin
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <b>ReturnsWithinOption</b> in a more user-friendly format to buyers. For example, in <b>GetItem</b> and related calls, this value is usually localized and can contain spaces.
     * <br/><br/> If necessary, you can predict the choice of values based on the <b>ReturnsWithin.Description</b> options returned by <b>GeteBayDetails</b>.<br> <br> Not applicable as input to the <b>AddItem</b> family of calls. (Use
     * <b>ReturnsWithinOption</b> instead.)
     * - minOccurs: 0
     * @var string
     */
    public $ReturnsWithin;
    /**
     * The ReturnsAcceptedOption
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the seller allows the buyer to return the item. This field is required when <b>ReturnPolicy</b> is specified. If you specify <b>ReturnsNotAccepted</b>, the View Item page will indicate that returns are not accepted
     * instead.)<br> <br> All sites support the ability for a seller to not accept returns. If the seller doesn't accept returns, the item must specifically indicate <b>ReturnsNotAccepted</b>. (The return policy cannot be omitted from the item.)<br> <br> On
     * the eBay UK and Ireland sites, business sellers must accept returns for fixed-price items (including auction items with Buy It Now, and any other fixed price formats) when the category requires a return policy. On some European sites (such as eBay
     * Germany (DE), registered business sellers are required to accept returns. Your application can call <b>GetUser</b> to determine a user's current business seller status. <br> <br> <span class="tablenote"><b>Note:</b> In order for Top-Rated sellers to
     * receive a Top-Rated Plus seal for their listings, returns must be accepted for the item (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) and handling time should be set to zero days (same-day shipping) or one day. The handling time is
     * set through an integer value in the <b>Item.DispatchTimeMax</b> field. <br/><br/> Top-Rated listings qualify for the greatest average boost in Best Match and for the 20 percent Final Value Fee discount. For more information on eBay's Top-Rated seller
     * program, see the <a href="http://pages.ebay.com/help/sell/top-rated.html">Becoming a Top Rated Seller and qualifying for Top Rated Plus</a> page. </span> <br> <b>Applicable values:</b> To get the applicable <b>ReturnsAcceptedOption</b> values for
     * your site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>, and then look for the <b>ReturnPolicyDetails.ReturnsAccepted.Description</b> fields in the response. <b>ReturnsAcceptedOptionsCodeType</b> defines all the
     * possible values.<br> <br> <b>For ReviseItem only:</b> If the listing has bids or sales and/or ends within 12 hours, you can't change this value. See the parent <b>ReturnPolicy</b> node description for more details.
     * - minOccurs: 0
     * @var string
     */
    public $ReturnsAcceptedOption;
    /**
     * The ReturnsAccepted
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <b>ReturnsAcceptedOption</b> in a more user-friendly format to buyers. For example, in <b>GetItem</b> and related calls, this value is usually localized and can contain
     * spaces. <br/><br/> If necessary, you can predict the choice of values based on the <b>ReturnsAccepted.Description</b> options returned by <b>GeteBayDetails</b>. <br> Not applicable as input to the <b>AddItem</b> family of calls. (Use
     * <b>ReturnsAcceptedOption</b> instead.)
     * - minOccurs: 0
     * @var string
     */
    public $ReturnsAccepted;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: A detailed explanation of the seller's return policy. <br> <br> eBay uses this text string as-is in the Return Policy section of the View Item page. Avoid HTML, and avoid character entity references (such as &amp;pound; or
     * &amp;#163;). If you include special characters in the return policy description, use the literal UTF-8 or ISO-8559-1 character (e.g. &#163;). <br> <br> <b>For AddItem, VerifyAddItem, and RelistItem:</b> If the seller accepts returns
     * (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but does not specify this field when listing the item, <b>GetItem</b> returns this as an empty node<br> <br> <b>For ReviseItem only:</b> If the listing has bids or sales and/or ends within
     * 12 hours, you can't change this value. See the parent <b>ReturnPolicy</b> node description for more details. <br>
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The WarrantyOfferedOption
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether a warranty is offered for the item. <b><br> Applicable values:</b> To get the applicable <b>WarrantyOfferedOption</b> values for your site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to
     * <b>ReturnPolicyDetails</b>, and then look for the <b>ReturnPolicyDetails.WarrantyOffered.WarrantyOfferedOption</b> fields in the response. WarrantyOfferedCodeType defines all the possible values.<br> <b>Note:</b> Only the eBay India site supports
     * this field. <br><br> <b>For AddItem, VerifyAddItem, and RelistItem:</b> If the seller accepts returns (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but you do not pass in this <b>WarrantyOfferedOption</b> field when listing the item,
     * the eBay India site may set a default value, and the seller is obligated to honor this setting. Therefore, to avoid unexpected obligations, the seller should set a specific value for this field.<br> <br> <span class="tablenote"><b>Note:</b> For the
     * US eBay Motors limited warranty (Short-Term Service Agreement) option, use <b>Item.LimitedWarrantyEligible</b> instead. <br><br> For the US eBay Motors "Is There an Existing Warranty?" option, use <b>Item.AttributeSetArray</b> instead. </span> <b>For
     * ReviseItem only:</b> If the listing has bids or sales and/or ends within 12 hours, you can't change this value. See the parent <b>ReturnPolicy</b> node description for more details.
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyOfferedOption;
    /**
     * The WarrantyOffered
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <b>WarrantyOfferedOption</b> in a more user-friendly format to buyers. For example, in <b>GetItem</b> and related calls, this value is usually localized and can contain
     * spaces. <br/><br/> If necessary, you can predict the choice of values based on the <b>WarrantyOffered.Description</b> options returned by <b>GeteBayDetails</b>.<br> <br> Not applicable as input to the <b>AddItem</b> family of calls. (Use
     * <b>WarrantyOfferedOption</b> instead.)
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyOffered;
    /**
     * The WarrantyTypeOption
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the source or type of the warranty, if any. <b>Note:</b> Only the eBay India site supports this field.<br> <br><b> Applicable values:</b> To get the applicable <b>WarrantyTypeOption</b> values for your site, call
     * <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>, and then look for the <b>ReturnPolicyDetails.WarrantyType.WarrantyTypeOption</b> fields in the response. <b>WarrantyTypeOptionsCodeType</b> defines all the possible
     * values. <br><br> <b>For AddItem, VerifyAddItem, and RelistItem:</b> If the seller accepts returns (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but you do not pass in this <b>WarrantyTypeOption</b> field when listing the item, the
     * eBay India site may set a default value, and the seller is obligated to honor this setting. Therefore, to avoid unexpected obligations, the seller should set a specific value for this field.<br> <br> <b>For ReviseItem only:</b> If the listing has
     * bids or sales and/or ends within 12 hours, you can't change this value. See the parent <b>ReturnPolicy</b> node description for more details.
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyTypeOption;
    /**
     * The WarrantyType
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <b>WarrantyTypeOption</b> in a more user-friendly format to buyers. For example, in <b>GetItem</b> and related calls, this value is usually localized and can contain spaces.
     * <br/><br/> If necessary, you can predict the choice of values based on the <b>WarrantyType.Description</b> options returned by <b>GeteBayDetails</b>.<br> <br> Not applicable as input to the <b>AddItem</b> family of calls. (Use
     * <b>WarrantyTypeOption</b> instead.)
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyType;
    /**
     * The WarrantyDurationOption
     * Meta informations extracted from the WSDL
     * - documentation: The warranty period.<br> <br> <b>Applicable values:</b> To get the applicable WarrantyDurationOption values for your site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>, and then look for the
     * <b>ReturnPolicyDetails.WarrantyDuration.WarrantyDurationOption</b> fields in the response. <b>WarrantyDurationOptionsCodeType</b> defines all the possible values.<br> <br> <b>For AddItem, VerifyAddItem, and RelistItem:</b> If the seller accepts
     * returns (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but you do not pass in this <b>WarrantyDurationOption</b> field when listing the item, the eBay India site may set a default value, and the seller is obligated to honor this
     * setting. Therefore, to avoid unexpected obligations, the seller should set a specific value for this field.<br> <br> <b>For ReviseItem only:</b> If the listing has bids or sales and/or ends within 12 hours, you can't change this value. See the parent
     * <b>ReturnPolicy</b> node description for more details.
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyDurationOption;
    /**
     * The WarrantyDuration
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <br/><br/>WarrantyDurationOption in a more user-friendly format to buyers. For example, <b>GetItem</b> and related calls, this value is usually localized and can contain
     * spaces. <br/><br/> If necessary, you can predict the choice of values based on the <b>WarrantyDuration.Description</b> options returned by <b>GeteBayDetails</b>.<br> <br> Not applicable as input to the <b>AddItem</b> family of calls. (Use
     * <b>WarrantyDurationOption</b> instead.)
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyDuration;
    /**
     * The ShippingCostPaidByOption
     * Meta informations extracted from the WSDL
     * - documentation: The party who pays the shipping cost for a returned item. Use the <b>ReturnPolicy.Descriptio</b> field to explain any additional details.<br> <br> <b>Applicable values:</b> To get the applicable <b>ShippingCostPaidByOption</b> values
     * for your site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>, and then look for the <b>ReturnPolicyDetails.ShippingCostPaidBy.ShippingCostPaidByOption</b> fields in the response.
     * <b>ShippingCostPaidByOptionsCodeType</b> defines all the possible values.<br> <br> <b>For AddItem, VerifyAddItem, and RelistItem:</b> If the seller accepts returns (<b>ReturnsAcceptedOption</b> = <code>ReturnsAccepted</code>) but you do not pass in
     * this <b>ShippingCostPaidByOption</b> field when listing the item, some eBay sites may set a default value (like Buyer), and the seller is obligated to honor this setting. Therefore, to avoid unexpected obligations, the seller should set a specific
     * value for this field.<br> <br> <b>For ReviseItem only:</b> If the listing has bids or sales and/or ends within 12 hours, you can't change this value. See the parent <b>ReturnPolicy</b> node description for more details.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCostPaidByOption;
    /**
     * The ShippingCostPaidBy
     * Meta informations extracted from the WSDL
     * - documentation: Display string that buyer applications can use to present <b>ShippingCostPaidByOption</b> in a more user-friendly format to buyers. For example, in <b>GetItem</b> and related calls, this value is usually localized and can contain
     * spaces. <br/><br/> If necessary, you can predict the choice of values based on the <b>ShippingCostPaidBy.Description</b> options returned by <b>GeteBayDetails</b>.<br> <br> Not applicable as input to the <b>AddItem</b> family of calls. (Use
     * <b>ShippingCostPaidByOption</b> instead.)
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCostPaidBy;
    /**
     * The RestockingFeeValue
     * Meta informations extracted from the WSDL
     * - documentation: Display string that indicates the restocking fee charged by the seller for returned items. This value is directly related to the <b>RestockingFeeValueOption</b> value, with the difference being that applications can use
     * <b>RestockingFeeValue</b> to present the <b>RestockingFeeValueOption</b> value in a more user-friendly format when used in a GUI features such as option buttons or drop-down lists.
     * - minOccurs: 0
     * @var string
     */
    public $RestockingFeeValue;
    /**
     * The RestockingFeeValueOption
     * Meta informations extracted from the WSDL
     * - documentation: This enumeration value indicates the restocking fee percentage values that a seller can charge to a buyer who is returning an item due to buyer remorse and/or a purchasing mistake. A restocking fee is not applicable for an item that
     * is being returned because it was not as described. Restocking fees are only applicable to the US and Canadian sellers who have opted into eBay Managed Returns. <br><br> In order to charge the buyer a restocking fee when an item is returned, a US
     * seller must input a restocking fee value at listing time (either through the <b>ReturnPolicy</b>) or through a Return Business Policy that is applied to the listing. <br><br> To obtain the list of currently supported values, call
     * <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ReturnPolicyDetails</b>. Then, look for the list of restocking fee percentage values in the <b>ReturnPolicyDetails.RestockingFeeValue</b> containers in the response. <br><br> <b>For Get
     * calls</b>: The <b>RestockingFeeValue</b> field is directly related to <b>RestockingFeeValueOption</b>, and gives a user-friendly description of the restocking fee policy.
     * - minOccurs: 0
     * @var string
     */
    public $RestockingFeeValueOption;
    /**
     * The ExtendedHolidayReturns
     * Meta informations extracted from the WSDL
     * - documentation: When you list an item by using the <b>Add</b>/<b>Revise</b>/<b>Relist</b> families of calls, use this field to enable an <em>Extended Holiday Returns</em> policy for the item. A value of <code>true</code> indicates the seller is
     * offering the item with an extended holiday returns period. <br/><br/> <span class="tablenote"> <strong>IMPORTANT:</strong> Extended Holiday Returns is a seasonally available feature, but it might not be made available every year. To ensure that the
     * feature is enabled in any given year, check the <a href="http://pages.ebay.com/sellerinformation/returns-on-eBay/" target="_blank">Returns on eBay</a> page of the eBay Seller Center before the holiday season starts. If the feature is not enabled for
     * the season, this field is ignored. </span> The extended holiday returns period is defined by three dates: <ul> <li>The start date - start of November.</li> <li>The purchase cutoff date - end of the year.</li> <li>The end date - end of January.</li>
     * </ul> <span class="tablenote"> <strong>Note:</strong> These dates may vary by a few days each year. Sellers will be notified of the current dates on their eBay site before the holiday period starts. </span> Sellers can specify Extended Holiday
     * Returns (as well as their regular non-holiday returns period) for chosen listings at any time during the year. The Extended Holiday Returns offer is not visible in the listings until the current year's holiday returns period start date, at which
     * point it overrides the non-holiday returns policy. Buyers will see and be subject to the Extended Holiday Returns offer in listings purchased through the purchase cutoff date, and will be able to return those purchases through the end date.
     * <br/><br/> After the purchase cutoff date, the Extended Holiday Returns offer automatically disappears from listings, and the seller's non-holiday returns period reappears. Purchases made from that point on are subject to the non-holiday returns
     * period, while purchases made before the cutoff date still have until the end date to be returned. <br/><br/> If the value of <strong>ExtendedHolidayReturns</strong> is <code>false</code> for an item, the returns period specified by the
     * <strong>ReturnsWithinOption</strong> field applies, regardless of the purchase date. If the item is listed with a policy of no returns, <strong>ExtendedHolidayReturns</strong> is automatically reset to <code>false</code>. <br/><br/> <strong>For the
     * AddItem family of calls</strong>, the value of <strong>ExtendedHolidayReturns</strong> is <code>false</code> by default. <br/><br/> <strong>For the ReviseItem family of calls</strong>, you can omit <strong>ExtendedHolidayReturns</strong> from the
     * input if its value does not need to change. If the item being revised has bids or orders, you can add the extended holiday returns option to the listing, but you can't remove it. If the item <em>does not</em> have bids or orders, you can add
     * <em>or</em> remove the extended holiday returns option; however, this is a significant revision, triggering a version change in the listing. <br/><br/> <strong>For the RelistItem family of calls</strong>, you can omit
     * <strong>ExtendedHolidayReturns</strong> from the input if its value does not need to change. <br/><br/> <strong>For the GetItem call</strong>, <strong>ExtendedHolidayReturns</strong> is returned only if the site you sent the request to supports the
     * seller's return policy. Typically, this is only when the request is sent to the listing site. <br/><br/> <span class="tablenote"> <strong>Note:</strong> Top-Rated Sellers offering Extended Holiday Returns on a listing will get an additional 5 percent
     * discount on the Final Value Fees on top of the 20 percent discount they get for creating Top-Rated Plus qualifying listings. See the <a href="http://pages.ebay.com/help/sell/top-rated.html">Becoming a Top Rated Seller and qualifying for Top Rated
     * Plus</a> help topic for more information on Top-Rated Seller, Top-Rated Plus requirements, and the 5 percent bonus discount for Extended Holiday Returns. </span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExtendedHolidayReturns;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ReturnPolicyType
     * @uses ReturnPolicyType::setRefundOption()
     * @uses ReturnPolicyType::setRefund()
     * @uses ReturnPolicyType::setReturnsWithinOption()
     * @uses ReturnPolicyType::setReturnsWithin()
     * @uses ReturnPolicyType::setReturnsAcceptedOption()
     * @uses ReturnPolicyType::setReturnsAccepted()
     * @uses ReturnPolicyType::setDescription()
     * @uses ReturnPolicyType::setWarrantyOfferedOption()
     * @uses ReturnPolicyType::setWarrantyOffered()
     * @uses ReturnPolicyType::setWarrantyTypeOption()
     * @uses ReturnPolicyType::setWarrantyType()
     * @uses ReturnPolicyType::setWarrantyDurationOption()
     * @uses ReturnPolicyType::setWarrantyDuration()
     * @uses ReturnPolicyType::setShippingCostPaidByOption()
     * @uses ReturnPolicyType::setShippingCostPaidBy()
     * @uses ReturnPolicyType::setRestockingFeeValue()
     * @uses ReturnPolicyType::setRestockingFeeValueOption()
     * @uses ReturnPolicyType::setExtendedHolidayReturns()
     * @uses ReturnPolicyType::setAny()
     * @param string $refundOption
     * @param string $refund
     * @param string $returnsWithinOption
     * @param string $returnsWithin
     * @param string $returnsAcceptedOption
     * @param string $returnsAccepted
     * @param string $description
     * @param string $warrantyOfferedOption
     * @param string $warrantyOffered
     * @param string $warrantyTypeOption
     * @param string $warrantyType
     * @param string $warrantyDurationOption
     * @param string $warrantyDuration
     * @param string $shippingCostPaidByOption
     * @param string $shippingCostPaidBy
     * @param string $restockingFeeValue
     * @param string $restockingFeeValueOption
     * @param bool $extendedHolidayReturns
     * @param \DOMDocument $any
     */
    public function __construct($refundOption = null, $refund = null, $returnsWithinOption = null, $returnsWithin = null, $returnsAcceptedOption = null, $returnsAccepted = null, $description = null, $warrantyOfferedOption = null, $warrantyOffered = null, $warrantyTypeOption = null, $warrantyType = null, $warrantyDurationOption = null, $warrantyDuration = null, $shippingCostPaidByOption = null, $shippingCostPaidBy = null, $restockingFeeValue = null, $restockingFeeValueOption = null, $extendedHolidayReturns = null, \DOMDocument $any = null)
    {
        $this
            ->setRefundOption($refundOption)
            ->setRefund($refund)
            ->setReturnsWithinOption($returnsWithinOption)
            ->setReturnsWithin($returnsWithin)
            ->setReturnsAcceptedOption($returnsAcceptedOption)
            ->setReturnsAccepted($returnsAccepted)
            ->setDescription($description)
            ->setWarrantyOfferedOption($warrantyOfferedOption)
            ->setWarrantyOffered($warrantyOffered)
            ->setWarrantyTypeOption($warrantyTypeOption)
            ->setWarrantyType($warrantyType)
            ->setWarrantyDurationOption($warrantyDurationOption)
            ->setWarrantyDuration($warrantyDuration)
            ->setShippingCostPaidByOption($shippingCostPaidByOption)
            ->setShippingCostPaidBy($shippingCostPaidBy)
            ->setRestockingFeeValue($restockingFeeValue)
            ->setRestockingFeeValueOption($restockingFeeValueOption)
            ->setExtendedHolidayReturns($extendedHolidayReturns)
            ->setAny($any);
    }
    /**
     * Get RefundOption value
     * @return string|null
     */
    public function getRefundOption()
    {
        return $this->RefundOption;
    }
    /**
     * Set RefundOption value
     * @param string $refundOption
     * @return \StructType\ReturnPolicyType
     */
    public function setRefundOption($refundOption = null)
    {
        // validation for constraint: string
        if (!is_null($refundOption) && !is_string($refundOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refundOption)), __LINE__);
        }
        $this->RefundOption = $refundOption;
        return $this;
    }
    /**
     * Get Refund value
     * @return string|null
     */
    public function getRefund()
    {
        return $this->Refund;
    }
    /**
     * Set Refund value
     * @param string $refund
     * @return \StructType\ReturnPolicyType
     */
    public function setRefund($refund = null)
    {
        // validation for constraint: string
        if (!is_null($refund) && !is_string($refund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refund)), __LINE__);
        }
        $this->Refund = $refund;
        return $this;
    }
    /**
     * Get ReturnsWithinOption value
     * @return string|null
     */
    public function getReturnsWithinOption()
    {
        return $this->ReturnsWithinOption;
    }
    /**
     * Set ReturnsWithinOption value
     * @param string $returnsWithinOption
     * @return \StructType\ReturnPolicyType
     */
    public function setReturnsWithinOption($returnsWithinOption = null)
    {
        // validation for constraint: string
        if (!is_null($returnsWithinOption) && !is_string($returnsWithinOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnsWithinOption)), __LINE__);
        }
        $this->ReturnsWithinOption = $returnsWithinOption;
        return $this;
    }
    /**
     * Get ReturnsWithin value
     * @return string|null
     */
    public function getReturnsWithin()
    {
        return $this->ReturnsWithin;
    }
    /**
     * Set ReturnsWithin value
     * @param string $returnsWithin
     * @return \StructType\ReturnPolicyType
     */
    public function setReturnsWithin($returnsWithin = null)
    {
        // validation for constraint: string
        if (!is_null($returnsWithin) && !is_string($returnsWithin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnsWithin)), __LINE__);
        }
        $this->ReturnsWithin = $returnsWithin;
        return $this;
    }
    /**
     * Get ReturnsAcceptedOption value
     * @return string|null
     */
    public function getReturnsAcceptedOption()
    {
        return $this->ReturnsAcceptedOption;
    }
    /**
     * Set ReturnsAcceptedOption value
     * @param string $returnsAcceptedOption
     * @return \StructType\ReturnPolicyType
     */
    public function setReturnsAcceptedOption($returnsAcceptedOption = null)
    {
        // validation for constraint: string
        if (!is_null($returnsAcceptedOption) && !is_string($returnsAcceptedOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnsAcceptedOption)), __LINE__);
        }
        $this->ReturnsAcceptedOption = $returnsAcceptedOption;
        return $this;
    }
    /**
     * Get ReturnsAccepted value
     * @return string|null
     */
    public function getReturnsAccepted()
    {
        return $this->ReturnsAccepted;
    }
    /**
     * Set ReturnsAccepted value
     * @param string $returnsAccepted
     * @return \StructType\ReturnPolicyType
     */
    public function setReturnsAccepted($returnsAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($returnsAccepted) && !is_string($returnsAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnsAccepted)), __LINE__);
        }
        $this->ReturnsAccepted = $returnsAccepted;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ReturnPolicyType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get WarrantyOfferedOption value
     * @return string|null
     */
    public function getWarrantyOfferedOption()
    {
        return $this->WarrantyOfferedOption;
    }
    /**
     * Set WarrantyOfferedOption value
     * @param string $warrantyOfferedOption
     * @return \StructType\ReturnPolicyType
     */
    public function setWarrantyOfferedOption($warrantyOfferedOption = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyOfferedOption) && !is_string($warrantyOfferedOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyOfferedOption)), __LINE__);
        }
        $this->WarrantyOfferedOption = $warrantyOfferedOption;
        return $this;
    }
    /**
     * Get WarrantyOffered value
     * @return string|null
     */
    public function getWarrantyOffered()
    {
        return $this->WarrantyOffered;
    }
    /**
     * Set WarrantyOffered value
     * @param string $warrantyOffered
     * @return \StructType\ReturnPolicyType
     */
    public function setWarrantyOffered($warrantyOffered = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyOffered) && !is_string($warrantyOffered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyOffered)), __LINE__);
        }
        $this->WarrantyOffered = $warrantyOffered;
        return $this;
    }
    /**
     * Get WarrantyTypeOption value
     * @return string|null
     */
    public function getWarrantyTypeOption()
    {
        return $this->WarrantyTypeOption;
    }
    /**
     * Set WarrantyTypeOption value
     * @param string $warrantyTypeOption
     * @return \StructType\ReturnPolicyType
     */
    public function setWarrantyTypeOption($warrantyTypeOption = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyTypeOption) && !is_string($warrantyTypeOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyTypeOption)), __LINE__);
        }
        $this->WarrantyTypeOption = $warrantyTypeOption;
        return $this;
    }
    /**
     * Get WarrantyType value
     * @return string|null
     */
    public function getWarrantyType()
    {
        return $this->WarrantyType;
    }
    /**
     * Set WarrantyType value
     * @param string $warrantyType
     * @return \StructType\ReturnPolicyType
     */
    public function setWarrantyType($warrantyType = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyType) && !is_string($warrantyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyType)), __LINE__);
        }
        $this->WarrantyType = $warrantyType;
        return $this;
    }
    /**
     * Get WarrantyDurationOption value
     * @return string|null
     */
    public function getWarrantyDurationOption()
    {
        return $this->WarrantyDurationOption;
    }
    /**
     * Set WarrantyDurationOption value
     * @param string $warrantyDurationOption
     * @return \StructType\ReturnPolicyType
     */
    public function setWarrantyDurationOption($warrantyDurationOption = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyDurationOption) && !is_string($warrantyDurationOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyDurationOption)), __LINE__);
        }
        $this->WarrantyDurationOption = $warrantyDurationOption;
        return $this;
    }
    /**
     * Get WarrantyDuration value
     * @return string|null
     */
    public function getWarrantyDuration()
    {
        return $this->WarrantyDuration;
    }
    /**
     * Set WarrantyDuration value
     * @param string $warrantyDuration
     * @return \StructType\ReturnPolicyType
     */
    public function setWarrantyDuration($warrantyDuration = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyDuration) && !is_string($warrantyDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyDuration)), __LINE__);
        }
        $this->WarrantyDuration = $warrantyDuration;
        return $this;
    }
    /**
     * Get ShippingCostPaidByOption value
     * @return string|null
     */
    public function getShippingCostPaidByOption()
    {
        return $this->ShippingCostPaidByOption;
    }
    /**
     * Set ShippingCostPaidByOption value
     * @param string $shippingCostPaidByOption
     * @return \StructType\ReturnPolicyType
     */
    public function setShippingCostPaidByOption($shippingCostPaidByOption = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCostPaidByOption) && !is_string($shippingCostPaidByOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingCostPaidByOption)), __LINE__);
        }
        $this->ShippingCostPaidByOption = $shippingCostPaidByOption;
        return $this;
    }
    /**
     * Get ShippingCostPaidBy value
     * @return string|null
     */
    public function getShippingCostPaidBy()
    {
        return $this->ShippingCostPaidBy;
    }
    /**
     * Set ShippingCostPaidBy value
     * @param string $shippingCostPaidBy
     * @return \StructType\ReturnPolicyType
     */
    public function setShippingCostPaidBy($shippingCostPaidBy = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCostPaidBy) && !is_string($shippingCostPaidBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingCostPaidBy)), __LINE__);
        }
        $this->ShippingCostPaidBy = $shippingCostPaidBy;
        return $this;
    }
    /**
     * Get RestockingFeeValue value
     * @return string|null
     */
    public function getRestockingFeeValue()
    {
        return $this->RestockingFeeValue;
    }
    /**
     * Set RestockingFeeValue value
     * @param string $restockingFeeValue
     * @return \StructType\ReturnPolicyType
     */
    public function setRestockingFeeValue($restockingFeeValue = null)
    {
        // validation for constraint: string
        if (!is_null($restockingFeeValue) && !is_string($restockingFeeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restockingFeeValue)), __LINE__);
        }
        $this->RestockingFeeValue = $restockingFeeValue;
        return $this;
    }
    /**
     * Get RestockingFeeValueOption value
     * @return string|null
     */
    public function getRestockingFeeValueOption()
    {
        return $this->RestockingFeeValueOption;
    }
    /**
     * Set RestockingFeeValueOption value
     * @param string $restockingFeeValueOption
     * @return \StructType\ReturnPolicyType
     */
    public function setRestockingFeeValueOption($restockingFeeValueOption = null)
    {
        // validation for constraint: string
        if (!is_null($restockingFeeValueOption) && !is_string($restockingFeeValueOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restockingFeeValueOption)), __LINE__);
        }
        $this->RestockingFeeValueOption = $restockingFeeValueOption;
        return $this;
    }
    /**
     * Get ExtendedHolidayReturns value
     * @return bool|null
     */
    public function getExtendedHolidayReturns()
    {
        return $this->ExtendedHolidayReturns;
    }
    /**
     * Set ExtendedHolidayReturns value
     * @param bool $extendedHolidayReturns
     * @return \StructType\ReturnPolicyType
     */
    public function setExtendedHolidayReturns($extendedHolidayReturns = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedHolidayReturns) && !is_bool($extendedHolidayReturns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extendedHolidayReturns)), __LINE__);
        }
        $this->ExtendedHolidayReturns = $extendedHolidayReturns;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\ReturnPolicyType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\ReturnPolicyType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReturnPolicyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
