<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRedirect StructType
 * @subpackage Structs
 */
class UserRedirect extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The rc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $rc;
    /**
     * The cn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cn;
    /**
     * The e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164;
    /**
     * The h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $h323;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * Constructor method for UserRedirect
     * @uses UserRedirect::setCall()
     * @uses UserRedirect::setRc()
     * @uses UserRedirect::setCn()
     * @uses UserRedirect::setE164()
     * @uses UserRedirect::setH323()
     * @uses UserRedirect::setInfo()
     * @param int $call
     * @param int $rc
     * @param string $cn
     * @param string $e164
     * @param string $h323
     * @param \StructType\Info[] $info
     */
    public function __construct($call = null, $rc = null, $cn = null, $e164 = null, $h323 = null, array $info = array())
    {
        $this
            ->setCall($call)
            ->setRc($rc)
            ->setCn($cn)
            ->setE164($e164)
            ->setH323($h323)
            ->setInfo($info);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserRedirect
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get rc value
     * @return int
     */
    public function getRc()
    {
        return $this->rc;
    }
    /**
     * Set rc value
     * @param int $rc
     * @return \StructType\UserRedirect
     */
    public function setRc($rc = null)
    {
        // validation for constraint: int
        if (!is_null($rc) && !is_numeric($rc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rc)), __LINE__);
        }
        $this->rc = $rc;
        return $this;
    }
    /**
     * Get cn value
     * @return string|null
     */
    public function getCn()
    {
        return $this->cn;
    }
    /**
     * Set cn value
     * @param string $cn
     * @return \StructType\UserRedirect
     */
    public function setCn($cn = null)
    {
        // validation for constraint: string
        if (!is_null($cn) && !is_string($cn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cn)), __LINE__);
        }
        $this->cn = $cn;
        return $this;
    }
    /**
     * Get e164 value
     * @return string|null
     */
    public function getE164()
    {
        return $this->e164;
    }
    /**
     * Set e164 value
     * @param string $e164
     * @return \StructType\UserRedirect
     */
    public function setE164($e164 = null)
    {
        // validation for constraint: string
        if (!is_null($e164) && !is_string($e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164)), __LINE__);
        }
        $this->e164 = $e164;
        return $this;
    }
    /**
     * Get h323 value
     * @return string|null
     */
    public function getH323()
    {
        return $this->h323;
    }
    /**
     * Set h323 value
     * @param string $h323
     * @return \StructType\UserRedirect
     */
    public function setH323($h323 = null)
    {
        // validation for constraint: string
        if (!is_null($h323) && !is_string($h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323)), __LINE__);
        }
        $this->h323 = $h323;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Info[]|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\UserRedirect
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $userRedirectInfoItem) {
            // validation for constraint: itemType
            if (!$userRedirectInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($userRedirectInfoItem) ? get_class($userRedirectInfoItem) : gettype($userRedirectInfoItem)), __LINE__);
            }
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\UserRedirect
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserRedirect
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
