<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInitialize StructType
 * @subpackage Structs
 */
class UserInitialize extends AbstractStructBase
{
    /**
     * The session
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $session;
    /**
     * The xfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $xfer;
    /**
     * The disc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $disc;
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The hw
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hw;
    /**
     * Constructor method for UserInitialize
     * @uses UserInitialize::setSession()
     * @uses UserInitialize::setXfer()
     * @uses UserInitialize::setDisc()
     * @uses UserInitialize::setUser()
     * @uses UserInitialize::setHw()
     * @param int $session
     * @param bool $xfer
     * @param bool $disc
     * @param string $user
     * @param string $hw
     */
    public function __construct($session = null, $xfer = null, $disc = null, $user = null, $hw = null)
    {
        $this
            ->setSession($session)
            ->setXfer($xfer)
            ->setDisc($disc)
            ->setUser($user)
            ->setHw($hw);
    }
    /**
     * Get session value
     * @return int
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param int $session
     * @return \StructType\UserInitialize
     */
    public function setSession($session = null)
    {
        // validation for constraint: int
        if (!is_null($session) && !is_numeric($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get xfer value
     * @return bool
     */
    public function getXfer()
    {
        return $this->xfer;
    }
    /**
     * Set xfer value
     * @param bool $xfer
     * @return \StructType\UserInitialize
     */
    public function setXfer($xfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($xfer) && !is_bool($xfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($xfer)), __LINE__);
        }
        $this->xfer = $xfer;
        return $this;
    }
    /**
     * Get disc value
     * @return bool
     */
    public function getDisc()
    {
        return $this->disc;
    }
    /**
     * Set disc value
     * @param bool $disc
     * @return \StructType\UserInitialize
     */
    public function setDisc($disc = null)
    {
        // validation for constraint: boolean
        if (!is_null($disc) && !is_bool($disc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($disc)), __LINE__);
        }
        $this->disc = $disc;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\UserInitialize
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get hw value
     * @return string|null
     */
    public function getHw()
    {
        return $this->hw;
    }
    /**
     * Set hw value
     * @param string $hw
     * @return \StructType\UserInitialize
     */
    public function setHw($hw = null)
    {
        // validation for constraint: string
        if (!is_null($hw) && !is_string($hw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hw)), __LINE__);
        }
        $this->hw = $hw;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserInitialize
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
