<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserEnd StructType
 * @subpackage Structs
 */
class UserEnd extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * Constructor method for UserEnd
     * @uses UserEnd::setUser()
     * @param int $user
     */
    public function __construct($user = null)
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\UserEnd
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserEnd
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
