<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserConnect StructType
 * @subpackage Structs
 */
class UserConnect extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * Constructor method for UserConnect
     * @uses UserConnect::setCall()
     * @param int $call
     */
    public function __construct($call = null)
    {
        $this
            ->setCall($call);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserConnect
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserConnect
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
