<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallsResponse StructType
 * @subpackage Structs
 */
class CallsResponse extends AbstractStructBase
{
    /**
     * The CallInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CallInfo[]
     */
    public $CallInfo;
    /**
     * Constructor method for CallsResponse
     * @uses CallsResponse::setCallInfo()
     * @param \StructType\CallInfo[] $callInfo
     */
    public function __construct(array $callInfo = array())
    {
        $this
            ->setCallInfo($callInfo);
    }
    /**
     * Get CallInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CallInfo[]|null
     */
    public function getCallInfo()
    {
        return isset($this->CallInfo) ? $this->CallInfo : null;
    }
    /**
     * Set CallInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CallInfo[] $callInfo
     * @return \StructType\CallsResponse
     */
    public function setCallInfo(array $callInfo = array())
    {
        foreach ($callInfo as $callsResponseCallInfoItem) {
            // validation for constraint: itemType
            if (!$callsResponseCallInfoItem instanceof \StructType\CallInfo) {
                throw new \InvalidArgumentException(sprintf('The CallInfo property can only contain items of \StructType\CallInfo, "%s" given', is_object($callsResponseCallInfoItem) ? get_class($callsResponseCallInfoItem) : gettype($callsResponseCallInfoItem)), __LINE__);
            }
        }
        if (is_null($callInfo) || (is_array($callInfo) && empty($callInfo))) {
            unset($this->CallInfo);
        } else {
            $this->CallInfo = $callInfo;
        }
        return $this;
    }
    /**
     * Add item to CallInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CallInfo $item
     * @return \StructType\CallsResponse
     */
    public function addToCallInfo(\StructType\CallInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallInfo) {
            throw new \InvalidArgumentException(sprintf('The CallInfo property can only contain items of \StructType\CallInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CallInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
