<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Version ServiceType
 */
$version = new \ServiceType\Version($options);
/**
 * Sample call for Version operation/method
 */
if ($version->Version(new \StructType\Version()) !== false) {
    print_r($version->getResult());
} else {
    print_r($version->getLastError());
}
/**
 * Samples for Echo ServiceType
 */
$echo = new \ServiceType\_Echo($options);
/**
 * Sample call for _Echo operation/method
 */
if ($echo->_Echo(new \StructType\_Echo()) !== false) {
    print_r($echo->getResult());
} else {
    print_r($echo->getLastError());
}
/**
 * Samples for Admin ServiceType
 */
$admin = new \ServiceType\Admin($options);
/**
 * Sample call for Admin operation/method
 */
if ($admin->Admin(new \StructType\Admin()) !== false) {
    print_r($admin->getResult());
} else {
    print_r($admin->getLastError());
}
/**
 * Samples for Initialize ServiceType
 */
$initialize = new \ServiceType\Initialize($options);
/**
 * Sample call for Initialize operation/method
 */
if ($initialize->Initialize(new \StructType\Initialize()) !== false) {
    print_r($initialize->getResult());
} else {
    print_r($initialize->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ServiceType\End($options);
/**
 * Sample call for End operation/method
 */
if ($end->End(new \StructType\End()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Poll ServiceType
 */
$poll = new \ServiceType\Poll($options);
/**
 * Sample call for Poll operation/method
 */
if ($poll->Poll(new \StructType\Poll()) !== false) {
    print_r($poll->getResult());
} else {
    print_r($poll->getLastError());
}
/**
 * Samples for License ServiceType
 */
$license = new \ServiceType\License($options);
/**
 * Sample call for License operation/method
 */
if ($license->License(new \StructType\License()) !== false) {
    print_r($license->getResult());
} else {
    print_r($license->getLastError());
}
/**
 * Samples for Devices ServiceType
 */
$devices = new \ServiceType\Devices($options);
/**
 * Sample call for Devices operation/method
 */
if ($devices->Devices(new \StructType\Devices()) !== false) {
    print_r($devices->getResult());
} else {
    print_r($devices->getLastError());
}
/**
 * Samples for Calls ServiceType
 */
$calls = new \ServiceType\Calls($options);
/**
 * Sample call for Calls operation/method
 */
if ($calls->Calls(new \StructType\Calls()) !== false) {
    print_r($calls->getResult());
} else {
    print_r($calls->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for UserInitialize operation/method
 */
if ($user->UserInitialize(new \StructType\UserInitialize()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserEnd operation/method
 */
if ($user->UserEnd(new \StructType\UserEnd()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserCall operation/method
 */
if ($user->UserCall(new \StructType\UserCall()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserClear operation/method
 */
if ($user->UserClear(new \StructType\UserClear()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserConnect operation/method
 */
if ($user->UserConnect(new \StructType\UserConnect()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserRc operation/method
 */
if ($user->UserRc(new \StructType\UserRc()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserInfo operation/method
 */
if ($user->UserInfo(new \StructType\UserInfoTx()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserDTMF operation/method
 */
if ($user->UserDTMF(new \StructType\UserDTMF()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserUUI operation/method
 */
if ($user->UserUUI(new \StructType\UserUUI()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserPickup operation/method
 */
if ($user->UserPickup(new \StructType\UserPickup()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserRedirect operation/method
 */
if ($user->UserRedirect(new \StructType\UserRedirect()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserReroute operation/method
 */
if ($user->UserReroute(new \StructType\UserReroute()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserTransfer operation/method
 */
if ($user->UserTransfer(new \StructType\UserTransfer()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserMediaTransfer operation/method
 */
if ($user->UserMediaTransfer(new \StructType\UserMediaTransfer()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserCtComplete operation/method
 */
if ($user->UserCtComplete(new \StructType\UserCtComplete()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserHold operation/method
 */
if ($user->UserHold(new \StructType\UserHold()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserRetrieve operation/method
 */
if ($user->UserRetrieve(new \StructType\UserRetrieve()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserPark operation/method
 */
if ($user->UserPark(new \StructType\UserPark()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserMessage operation/method
 */
if ($user->UserMessage(new \StructType\UserMessage()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserLocalNum operation/method
 */
if ($user->UserLocalNum(new \StructType\UserLocalNum()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserFindDestination operation/method
 */
if ($user->UserFindDestination(new \StructType\UserFindDestination()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserLicense operation/method
 */
if ($user->UserLicense(new \StructType\UserLicense()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for FindUser operation/method
 */
if ($find->FindUser(new \StructType\FindUser()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetPresence operation/method
 */
if ($set->SetPresence(new \StructType\SetPresence()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Location ServiceType
 */
$location = new \ServiceType\Location($options);
/**
 * Sample call for LocationUrl operation/method
 */
if ($location->LocationUrl(new \StructType\LocationUrl()) !== false) {
    print_r($location->getResult());
} else {
    print_r($location->getLastError());
}
