<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Echo StructType
 * @subpackage Structs
 */
class _Echo extends AbstractStructBase
{
    /**
     * The session
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $session;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $key;
    /**
     * Constructor method for Echo
     * @uses _Echo::setSession()
     * @uses _Echo::setKey()
     * @param int $session
     * @param int $key
     */
    public function __construct($session = null, $key = null)
    {
        $this
            ->setSession($session)
            ->setKey($key);
    }
    /**
     * Get session value
     * @return int
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param int $session
     * @return \StructType\_Echo
     */
    public function setSession($session = null)
    {
        // validation for constraint: int
        if (!is_null($session) && !is_numeric($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get key value
     * @return int
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param int $key
     * @return \StructType\_Echo
     */
    public function setKey($key = null)
    {
        // validation for constraint: int
        if (!is_null($key) && !is_numeric($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\_Echo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
