<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserUUI StructType
 * @subpackage Structs
 */
class UserUUI extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The recv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $recv;
    /**
     * The uui
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uui;
    /**
     * Constructor method for UserUUI
     * @uses UserUUI::setCall()
     * @uses UserUUI::setRecv()
     * @uses UserUUI::setUui()
     * @param int $call
     * @param bool $recv
     * @param string $uui
     */
    public function __construct($call = null, $recv = null, $uui = null)
    {
        $this
            ->setCall($call)
            ->setRecv($recv)
            ->setUui($uui);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserUUI
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get recv value
     * @return bool
     */
    public function getRecv()
    {
        return $this->recv;
    }
    /**
     * Set recv value
     * @param bool $recv
     * @return \StructType\UserUUI
     */
    public function setRecv($recv = null)
    {
        // validation for constraint: boolean
        if (!is_null($recv) && !is_bool($recv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($recv)), __LINE__);
        }
        $this->recv = $recv;
        return $this;
    }
    /**
     * Get uui value
     * @return string|null
     */
    public function getUui()
    {
        return $this->uui;
    }
    /**
     * Set uui value
     * @param string $uui
     * @return \StructType\UserUUI
     */
    public function setUui($uui = null)
    {
        // validation for constraint: string
        if (!is_null($uui) && !is_string($uui)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uui)), __LINE__);
        }
        $this->uui = $uui;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserUUI
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
