<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRc StructType
 * @subpackage Structs
 */
class UserRc extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The rc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $rc;
    /**
     * Constructor method for UserRc
     * @uses UserRc::setCall()
     * @uses UserRc::setRc()
     * @param int $call
     * @param int $rc
     */
    public function __construct($call = null, $rc = null)
    {
        $this
            ->setCall($call)
            ->setRc($rc);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserRc
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get rc value
     * @return int
     */
    public function getRc()
    {
        return $this->rc;
    }
    /**
     * Set rc value
     * @param int $rc
     * @return \StructType\UserRc
     */
    public function setRc($rc = null)
    {
        // validation for constraint: int
        if (!is_null($rc) && !is_numeric($rc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rc)), __LINE__);
        }
        $this->rc = $rc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserRc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
