<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserCall StructType
 * @subpackage Structs
 */
class UserCall extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * The reg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reg;
    /**
     * The rc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $rc;
    /**
     * The cn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cn;
    /**
     * The e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164;
    /**
     * The h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $h323;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * The srce164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $srce164;
    /**
     * Constructor method for UserCall
     * @uses UserCall::setUser()
     * @uses UserCall::setReg()
     * @uses UserCall::setRc()
     * @uses UserCall::setCn()
     * @uses UserCall::setE164()
     * @uses UserCall::setH323()
     * @uses UserCall::setInfo()
     * @uses UserCall::setSrce164()
     * @param int $user
     * @param int $reg
     * @param int $rc
     * @param string $cn
     * @param string $e164
     * @param string $h323
     * @param \StructType\Info[] $info
     * @param string $srce164
     */
    public function __construct($user = null, $reg = null, $rc = null, $cn = null, $e164 = null, $h323 = null, array $info = array(), $srce164 = null)
    {
        $this
            ->setUser($user)
            ->setReg($reg)
            ->setRc($rc)
            ->setCn($cn)
            ->setE164($e164)
            ->setH323($h323)
            ->setInfo($info)
            ->setSrce164($srce164);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\UserCall
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get reg value
     * @return int
     */
    public function getReg()
    {
        return $this->reg;
    }
    /**
     * Set reg value
     * @param int $reg
     * @return \StructType\UserCall
     */
    public function setReg($reg = null)
    {
        // validation for constraint: int
        if (!is_null($reg) && !is_numeric($reg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reg)), __LINE__);
        }
        $this->reg = $reg;
        return $this;
    }
    /**
     * Get rc value
     * @return int
     */
    public function getRc()
    {
        return $this->rc;
    }
    /**
     * Set rc value
     * @param int $rc
     * @return \StructType\UserCall
     */
    public function setRc($rc = null)
    {
        // validation for constraint: int
        if (!is_null($rc) && !is_numeric($rc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rc)), __LINE__);
        }
        $this->rc = $rc;
        return $this;
    }
    /**
     * Get cn value
     * @return string|null
     */
    public function getCn()
    {
        return $this->cn;
    }
    /**
     * Set cn value
     * @param string $cn
     * @return \StructType\UserCall
     */
    public function setCn($cn = null)
    {
        // validation for constraint: string
        if (!is_null($cn) && !is_string($cn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cn)), __LINE__);
        }
        $this->cn = $cn;
        return $this;
    }
    /**
     * Get e164 value
     * @return string|null
     */
    public function getE164()
    {
        return $this->e164;
    }
    /**
     * Set e164 value
     * @param string $e164
     * @return \StructType\UserCall
     */
    public function setE164($e164 = null)
    {
        // validation for constraint: string
        if (!is_null($e164) && !is_string($e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164)), __LINE__);
        }
        $this->e164 = $e164;
        return $this;
    }
    /**
     * Get h323 value
     * @return string|null
     */
    public function getH323()
    {
        return $this->h323;
    }
    /**
     * Set h323 value
     * @param string $h323
     * @return \StructType\UserCall
     */
    public function setH323($h323 = null)
    {
        // validation for constraint: string
        if (!is_null($h323) && !is_string($h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323)), __LINE__);
        }
        $this->h323 = $h323;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Info[]|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\UserCall
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $userCallInfoItem) {
            // validation for constraint: itemType
            if (!$userCallInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($userCallInfoItem) ? get_class($userCallInfoItem) : gettype($userCallInfoItem)), __LINE__);
            }
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\UserCall
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Get srce164 value
     * @return string|null
     */
    public function getSrce164()
    {
        return $this->srce164;
    }
    /**
     * Set srce164 value
     * @param string $srce164
     * @return \StructType\UserCall
     */
    public function setSrce164($srce164 = null)
    {
        // validation for constraint: string
        if (!is_null($srce164) && !is_string($srce164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srce164)), __LINE__);
        }
        $this->srce164 = $srce164;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserCall
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
