<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegInfo StructType
 * @subpackage Structs
 */
class RegInfo extends AbstractStructBase
{
    /**
     * The active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $active;
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $user;
    /**
     * The reg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $reg;
    /**
     * The hw
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hw;
    /**
     * The soap
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $soap;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * Constructor method for RegInfo
     * @uses RegInfo::setActive()
     * @uses RegInfo::setUser()
     * @uses RegInfo::setReg()
     * @uses RegInfo::setHw()
     * @uses RegInfo::setSoap()
     * @uses RegInfo::setInfo()
     * @param bool $active
     * @param int $user
     * @param int $reg
     * @param string $hw
     * @param string $soap
     * @param \StructType\Info[] $info
     */
    public function __construct($active = null, $user = null, $reg = null, $hw = null, $soap = null, array $info = array())
    {
        $this
            ->setActive($active)
            ->setUser($user)
            ->setReg($reg)
            ->setHw($hw)
            ->setSoap($soap)
            ->setInfo($info);
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\RegInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get user value
     * @return int|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\RegInfo
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get reg value
     * @return int|null
     */
    public function getReg()
    {
        return $this->reg;
    }
    /**
     * Set reg value
     * @param int $reg
     * @return \StructType\RegInfo
     */
    public function setReg($reg = null)
    {
        // validation for constraint: int
        if (!is_null($reg) && !is_numeric($reg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reg)), __LINE__);
        }
        $this->reg = $reg;
        return $this;
    }
    /**
     * Get hw value
     * @return string|null
     */
    public function getHw()
    {
        return $this->hw;
    }
    /**
     * Set hw value
     * @param string $hw
     * @return \StructType\RegInfo
     */
    public function setHw($hw = null)
    {
        // validation for constraint: string
        if (!is_null($hw) && !is_string($hw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hw)), __LINE__);
        }
        $this->hw = $hw;
        return $this;
    }
    /**
     * Get soap value
     * @return string|null
     */
    public function getSoap()
    {
        return $this->soap;
    }
    /**
     * Set soap value
     * @param string $soap
     * @return \StructType\RegInfo
     */
    public function setSoap($soap = null)
    {
        // validation for constraint: string
        if (!is_null($soap) && !is_string($soap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($soap)), __LINE__);
        }
        $this->soap = $soap;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Info[]|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\RegInfo
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $regInfoInfoItem) {
            // validation for constraint: itemType
            if (!$regInfoInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($regInfoInfoItem) ? get_class($regInfoInfoItem) : gettype($regInfoInfoItem)), __LINE__);
            }
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\RegInfo
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
