<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calls StructType
 * @subpackage Structs
 */
class Calls extends AbstractStructBase
{
    /**
     * The session
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $session;
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * Constructor method for Calls
     * @uses Calls::setSession()
     * @uses Calls::setUser()
     * @param int $session
     * @param string $user
     */
    public function __construct($session = null, $user = null)
    {
        $this
            ->setSession($session)
            ->setUser($user);
    }
    /**
     * Get session value
     * @return int
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param int $session
     * @return \StructType\Calls
     */
    public function setSession($session = null)
    {
        // validation for constraint: int
        if (!is_null($session) && !is_numeric($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\Calls
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
