<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Info' => '\\StructType\\Info',
            'No' => '\\StructType\\No',
            'Group' => '\\StructType\\Group',
            'Device' => '\\StructType\\Device',
            'CallInfo' => '\\StructType\\CallInfo',
            'Presence' => '\\StructType\\Presence',
            'UserInfo' => '\\StructType\\UserInfo',
            'UserInfoArray' => '\\ArrayType\\UserInfoArray',
            'RegInfo' => '\\StructType\\RegInfo',
            'AnyInfo' => '\\StructType\\AnyInfo',
            'Version' => '\\StructType\\Version',
            'VersionResponse' => '\\StructType\\VersionResponse',
            'Echo' => '\\StructType\\_Echo',
            'EchoResponse' => '\\StructType\\EchoResponse',
            'Admin' => '\\StructType\\Admin',
            'AdminResponse' => '\\StructType\\AdminResponse',
            'Initialize' => '\\StructType\\Initialize',
            'InitializeResponse' => '\\StructType\\InitializeResponse',
            'End' => '\\StructType\\End',
            'EndResponse' => '\\StructType\\EndResponse',
            'Poll' => '\\StructType\\Poll',
            'PollResponse' => '\\StructType\\PollResponse',
            'License' => '\\StructType\\License',
            'LicenseResponse' => '\\StructType\\LicenseResponse',
            'Calls' => '\\StructType\\Calls',
            'CallsResponse' => '\\StructType\\CallsResponse',
            'Devices' => '\\StructType\\Devices',
            'DevicesResponse' => '\\StructType\\DevicesResponse',
            'UserInitialize' => '\\StructType\\UserInitialize',
            'UserInitializeResponse' => '\\StructType\\UserInitializeResponse',
            'UserEnd' => '\\StructType\\UserEnd',
            'UserEndResponse' => '\\StructType\\UserEndResponse',
            'UserCall' => '\\StructType\\UserCall',
            'UserCallResponse' => '\\StructType\\UserCallResponse',
            'UserClear' => '\\StructType\\UserClear',
            'UserClearResponse' => '\\StructType\\UserClearResponse',
            'UserConnect' => '\\StructType\\UserConnect',
            'UserConnectResponse' => '\\StructType\\UserConnectResponse',
            'UserRc' => '\\StructType\\UserRc',
            'UserRcResponse' => '\\StructType\\UserRcResponse',
            'UserInfoTx' => '\\StructType\\UserInfoTx',
            'UserInfoTxResponse' => '\\StructType\\UserInfoTxResponse',
            'UserDTMF' => '\\StructType\\UserDTMF',
            'UserDTMFResponse' => '\\StructType\\UserDTMFResponse',
            'UserUUI' => '\\StructType\\UserUUI',
            'UserUUIResponse' => '\\StructType\\UserUUIResponse',
            'UserPickup' => '\\StructType\\UserPickup',
            'UserPickupResponse' => '\\StructType\\UserPickupResponse',
            'UserRedirect' => '\\StructType\\UserRedirect',
            'UserRedirectResponse' => '\\StructType\\UserRedirectResponse',
            'UserReroute' => '\\StructType\\UserReroute',
            'UserRerouteResponse' => '\\StructType\\UserRerouteResponse',
            'UserTransfer' => '\\StructType\\UserTransfer',
            'UserTransferResponse' => '\\StructType\\UserTransferResponse',
            'UserMediaTransfer' => '\\StructType\\UserMediaTransfer',
            'UserMediaTransferResponse' => '\\StructType\\UserMediaTransferResponse',
            'UserCtComplete' => '\\StructType\\UserCtComplete',
            'UserCtCompleteResponse' => '\\StructType\\UserCtCompleteResponse',
            'UserHold' => '\\StructType\\UserHold',
            'UserHoldResponse' => '\\StructType\\UserHoldResponse',
            'UserRetrieve' => '\\StructType\\UserRetrieve',
            'UserRetrieveResponse' => '\\StructType\\UserRetrieveResponse',
            'UserPark' => '\\StructType\\UserPark',
            'UserParkResponse' => '\\StructType\\UserParkResponse',
            'UserMessage' => '\\StructType\\UserMessage',
            'UserMessageResponse' => '\\StructType\\UserMessageResponse',
            'UserLocalNum' => '\\StructType\\UserLocalNum',
            'UserLocalNumResponse' => '\\StructType\\UserLocalNumResponse',
            'UserFindDestination' => '\\StructType\\UserFindDestination',
            'UserFindDestinationResponse' => '\\StructType\\UserFindDestinationResponse',
            'FindUser' => '\\StructType\\FindUser',
            'FindUserResponse' => '\\StructType\\FindUserResponse',
            'UserLicense' => '\\StructType\\UserLicense',
            'UserLicenseResponse' => '\\StructType\\UserLicenseResponse',
            'SetPresence' => '\\StructType\\SetPresence',
            'SetPresenceResponse' => '\\StructType\\SetPresenceResponse',
            'LocationUrl' => '\\StructType\\LocationUrl',
            'LocationUrlResponse' => '\\StructType\\LocationUrlResponse',
        );
    }
}
