<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for UserInfoArray ArrayType
 * @subpackage Arrays
 */
class UserInfoArray extends AbstractStructArrayBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserInfo[]
     */
    public $user;
    /**
     * Constructor method for UserInfoArray
     * @uses UserInfoArray::setUser()
     * @param \StructType\UserInfo[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserInfo[]|null
     */
    public function getUser()
    {
        return isset($this->user) ? $this->user : null;
    }
    /**
     * Set user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo[] $user
     * @return \ArrayType\UserInfoArray
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $userInfoArrayUserItem) {
            // validation for constraint: itemType
            if (!$userInfoArrayUserItem instanceof \StructType\UserInfo) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($userInfoArrayUserItem) ? get_class($userInfoArrayUserItem) : gettype($userInfoArrayUserItem)), __LINE__);
            }
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->user);
        } else {
            $this->user = $user;
        }
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo $item
     * @return \ArrayType\UserInfoArray
     */
    public function addToUser(\StructType\UserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserInfo) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UserInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UserInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UserInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UserInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UserInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string user
     */
    public function getAttributeName()
    {
        return 'user';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\UserInfoArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
