<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserPickup StructType
 * @subpackage Structs
 */
class UserPickup extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The reg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reg;
    /**
     * The cn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cn;
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $group;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * Constructor method for UserPickup
     * @uses UserPickup::setUser()
     * @uses UserPickup::setCall()
     * @uses UserPickup::setReg()
     * @uses UserPickup::setCn()
     * @uses UserPickup::setGroup()
     * @uses UserPickup::setInfo()
     * @param int $user
     * @param int $call
     * @param int $reg
     * @param string $cn
     * @param string $group
     * @param \StructType\Info[] $info
     */
    public function __construct($user = null, $call = null, $reg = null, $cn = null, $group = null, array $info = array())
    {
        $this
            ->setUser($user)
            ->setCall($call)
            ->setReg($reg)
            ->setCn($cn)
            ->setGroup($group)
            ->setInfo($info);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\UserPickup
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserPickup
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get reg value
     * @return int
     */
    public function getReg()
    {
        return $this->reg;
    }
    /**
     * Set reg value
     * @param int $reg
     * @return \StructType\UserPickup
     */
    public function setReg($reg = null)
    {
        // validation for constraint: int
        if (!is_null($reg) && !is_numeric($reg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reg)), __LINE__);
        }
        $this->reg = $reg;
        return $this;
    }
    /**
     * Get cn value
     * @return string|null
     */
    public function getCn()
    {
        return $this->cn;
    }
    /**
     * Set cn value
     * @param string $cn
     * @return \StructType\UserPickup
     */
    public function setCn($cn = null)
    {
        // validation for constraint: string
        if (!is_null($cn) && !is_string($cn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cn)), __LINE__);
        }
        $this->cn = $cn;
        return $this;
    }
    /**
     * Get group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param string $group
     * @return \StructType\UserPickup
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Info[]|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\UserPickup
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $userPickupInfoItem) {
            // validation for constraint: itemType
            if (!$userPickupInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($userPickupInfoItem) ? get_class($userPickupInfoItem) : gettype($userPickupInfoItem)), __LINE__);
            }
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\UserPickup
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserPickup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
