<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserMessage StructType
 * @subpackage Structs
 */
class UserMessage extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * The e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164;
    /**
     * The h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $h323;
    /**
     * The msg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $msg;
    /**
     * The src_e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $src_e164;
    /**
     * The src_h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $src_h323;
    /**
     * Constructor method for UserMessage
     * @uses UserMessage::setUser()
     * @uses UserMessage::setE164()
     * @uses UserMessage::setH323()
     * @uses UserMessage::setMsg()
     * @uses UserMessage::setSrc_e164()
     * @uses UserMessage::setSrc_h323()
     * @param int $user
     * @param string $e164
     * @param string $h323
     * @param string $msg
     * @param string $src_e164
     * @param string $src_h323
     */
    public function __construct($user = null, $e164 = null, $h323 = null, $msg = null, $src_e164 = null, $src_h323 = null)
    {
        $this
            ->setUser($user)
            ->setE164($e164)
            ->setH323($h323)
            ->setMsg($msg)
            ->setSrc_e164($src_e164)
            ->setSrc_h323($src_h323);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\UserMessage
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get e164 value
     * @return string|null
     */
    public function getE164()
    {
        return $this->e164;
    }
    /**
     * Set e164 value
     * @param string $e164
     * @return \StructType\UserMessage
     */
    public function setE164($e164 = null)
    {
        // validation for constraint: string
        if (!is_null($e164) && !is_string($e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164)), __LINE__);
        }
        $this->e164 = $e164;
        return $this;
    }
    /**
     * Get h323 value
     * @return string|null
     */
    public function getH323()
    {
        return $this->h323;
    }
    /**
     * Set h323 value
     * @param string $h323
     * @return \StructType\UserMessage
     */
    public function setH323($h323 = null)
    {
        // validation for constraint: string
        if (!is_null($h323) && !is_string($h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323)), __LINE__);
        }
        $this->h323 = $h323;
        return $this;
    }
    /**
     * Get msg value
     * @return string|null
     */
    public function getMsg()
    {
        return $this->msg;
    }
    /**
     * Set msg value
     * @param string $msg
     * @return \StructType\UserMessage
     */
    public function setMsg($msg = null)
    {
        // validation for constraint: string
        if (!is_null($msg) && !is_string($msg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msg)), __LINE__);
        }
        $this->msg = $msg;
        return $this;
    }
    /**
     * Get src_e164 value
     * @return string|null
     */
    public function getSrc_e164()
    {
        return $this->src_e164;
    }
    /**
     * Set src_e164 value
     * @param string $src_e164
     * @return \StructType\UserMessage
     */
    public function setSrc_e164($src_e164 = null)
    {
        // validation for constraint: string
        if (!is_null($src_e164) && !is_string($src_e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($src_e164)), __LINE__);
        }
        $this->src_e164 = $src_e164;
        return $this;
    }
    /**
     * Get src_h323 value
     * @return string|null
     */
    public function getSrc_h323()
    {
        return $this->src_h323;
    }
    /**
     * Set src_h323 value
     * @param string $src_h323
     * @return \StructType\UserMessage
     */
    public function setSrc_h323($src_h323 = null)
    {
        // validation for constraint: string
        if (!is_null($src_h323) && !is_string($src_h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($src_h323)), __LINE__);
        }
        $this->src_h323 = $src_h323;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
