<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserLocalNum StructType
 * @subpackage Structs
 */
class UserLocalNum extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * The num
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $num;
    /**
     * Constructor method for UserLocalNum
     * @uses UserLocalNum::setUser()
     * @uses UserLocalNum::setNum()
     * @param int $user
     * @param string $num
     */
    public function __construct($user = null, $num = null)
    {
        $this
            ->setUser($user)
            ->setNum($num);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\UserLocalNum
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get num value
     * @return string|null
     */
    public function getNum()
    {
        return $this->num;
    }
    /**
     * Set num value
     * @param string $num
     * @return \StructType\UserLocalNum
     */
    public function setNum($num = null)
    {
        // validation for constraint: string
        if (!is_null($num) && !is_string($num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($num)), __LINE__);
        }
        $this->num = $num;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserLocalNum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
